/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Group;
import software.amazon.awssdk.services.quicksight.model.GroupListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchGroupsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, SearchGroupsResponse> {
    private static final SdkField<List<Group>> GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupList").getter(SearchGroupsResponse.getter(SearchGroupsResponse::groupList)).setter(SearchGroupsResponse.setter(Builder::groupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchGroupsResponse.getter(SearchGroupsResponse::nextToken)).setter(SearchGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SearchGroupsResponse.getter(SearchGroupsResponse::requestId)).setter(SearchGroupsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(SearchGroupsResponse.getter(SearchGroupsResponse::status)).setter(SearchGroupsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupList", GROUP_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final List<Group> groupList;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private SearchGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.groupList = builder.groupList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasGroupList() {
        return this.groupList != null && !(this.groupList instanceof SdkAutoConstructList);
    }

    public final List<Group> groupList() {
        return this.groupList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupList() ? this.groupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupsResponse)) {
            return false;
        }
        SearchGroupsResponse other = (SearchGroupsResponse)((Object)obj);
        return this.hasGroupList() == other.hasGroupList() && Objects.equals(this.groupList(), other.groupList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"SearchGroupsResponse").add("GroupList", this.hasGroupList() ? this.groupList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupList": {
                return Optional.ofNullable(clazz.cast(this.groupList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupsResponse, T> g) {
        return obj -> g.apply((SearchGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<Group> groupList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupsResponse model) {
            super(model);
            this.groupList(model.groupList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final List<Group.Builder> getGroupList() {
            List<Group.Builder> result = GroupListCopier.copyToBuilder(this.groupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupList(Collection<Group.BuilderImpl> groupList) {
            this.groupList = GroupListCopier.copyFromBuilder(groupList);
        }

        @Override
        public final Builder groupList(Collection<Group> groupList) {
            this.groupList = GroupListCopier.copy(groupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(Group ... groupList) {
            this.groupList(Arrays.asList(groupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupList(Consumer<Group.Builder> ... groupList) {
            this.groupList(Stream.of(groupList).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public SearchGroupsResponse build() {
            return new SearchGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchGroupsResponse> {
        public Builder groupList(Collection<Group> var1);

        public Builder groupList(Group ... var1);

        public Builder groupList(Consumer<Group.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

