/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PersonalizationMode;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQPersonalizationConfigurationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateQPersonalizationConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateQPersonalizationConfigurationRequest.getter(UpdateQPersonalizationConfigurationRequest::awsAccountId)).setter(UpdateQPersonalizationConfigurationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> PERSONALIZATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersonalizationMode").getter(UpdateQPersonalizationConfigurationRequest.getter(UpdateQPersonalizationConfigurationRequest::personalizationModeAsString)).setter(UpdateQPersonalizationConfigurationRequest.setter(Builder::personalizationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, PERSONALIZATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("PersonalizationMode", PERSONALIZATION_MODE_FIELD);
        }
    });
    private final String awsAccountId;
    private final String personalizationMode;

    private UpdateQPersonalizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.personalizationMode = builder.personalizationMode;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final PersonalizationMode personalizationMode() {
        return PersonalizationMode.fromValue(this.personalizationMode);
    }

    public final String personalizationModeAsString() {
        return this.personalizationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQPersonalizationConfigurationRequest)) {
            return false;
        }
        UpdateQPersonalizationConfigurationRequest other = (UpdateQPersonalizationConfigurationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.personalizationModeAsString(), other.personalizationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQPersonalizationConfigurationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("PersonalizationMode", (Object)this.personalizationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "PersonalizationMode": {
                return Optional.ofNullable(clazz.cast(this.personalizationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateQPersonalizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateQPersonalizationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String personalizationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQPersonalizationConfigurationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.personalizationMode(model.personalizationMode);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getPersonalizationMode() {
            return this.personalizationMode;
        }

        public final void setPersonalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
        }

        @Override
        public final Builder personalizationMode(String personalizationMode) {
            this.personalizationMode = personalizationMode;
            return this;
        }

        @Override
        public final Builder personalizationMode(PersonalizationMode personalizationMode) {
            this.personalizationMode(personalizationMode == null ? null : personalizationMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQPersonalizationConfigurationRequest build() {
            return new UpdateQPersonalizationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQPersonalizationConfigurationRequest> {
        public Builder awsAccountId(String var1);

        public Builder personalizationMode(String var1);

        public Builder personalizationMode(PersonalizationMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

