/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.NumericFormatConfiguration;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineValueLabelRelativePosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLineValueLabelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLineValueLabelConfiguration> {
    private static final SdkField<String> RELATIVE_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativePosition").getter(ReferenceLineValueLabelConfiguration.getter(ReferenceLineValueLabelConfiguration::relativePositionAsString)).setter(ReferenceLineValueLabelConfiguration.setter(Builder::relativePosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePosition").build()}).build();
    private static final SdkField<NumericFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatConfiguration").getter(ReferenceLineValueLabelConfiguration.getter(ReferenceLineValueLabelConfiguration::formatConfiguration)).setter(ReferenceLineValueLabelConfiguration.setter(Builder::formatConfiguration)).constructor(NumericFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIVE_POSITION_FIELD, FORMAT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RelativePosition", RELATIVE_POSITION_FIELD);
            this.put("FormatConfiguration", FORMAT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String relativePosition;
    private final NumericFormatConfiguration formatConfiguration;

    private ReferenceLineValueLabelConfiguration(BuilderImpl builder) {
        this.relativePosition = builder.relativePosition;
        this.formatConfiguration = builder.formatConfiguration;
    }

    public final ReferenceLineValueLabelRelativePosition relativePosition() {
        return ReferenceLineValueLabelRelativePosition.fromValue(this.relativePosition);
    }

    public final String relativePositionAsString() {
        return this.relativePosition;
    }

    public final NumericFormatConfiguration formatConfiguration() {
        return this.formatConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineValueLabelConfiguration)) {
            return false;
        }
        ReferenceLineValueLabelConfiguration other = (ReferenceLineValueLabelConfiguration)obj;
        return Objects.equals(this.relativePositionAsString(), other.relativePositionAsString()) && Objects.equals(this.formatConfiguration(), other.formatConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLineValueLabelConfiguration").add("RelativePosition", (Object)this.relativePositionAsString()).add("FormatConfiguration", (Object)this.formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RelativePosition": {
                return Optional.ofNullable(clazz.cast(this.relativePositionAsString()));
            }
            case "FormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.formatConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineValueLabelConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineValueLabelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relativePosition;
        private NumericFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineValueLabelConfiguration model) {
            this.relativePosition(model.relativePosition);
            this.formatConfiguration(model.formatConfiguration);
        }

        public final String getRelativePosition() {
            return this.relativePosition;
        }

        public final void setRelativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
        }

        @Override
        public final Builder relativePosition(String relativePosition) {
            this.relativePosition = relativePosition;
            return this;
        }

        @Override
        public final Builder relativePosition(ReferenceLineValueLabelRelativePosition relativePosition) {
            this.relativePosition(relativePosition == null ? null : relativePosition.toString());
            return this;
        }

        public final NumericFormatConfiguration.Builder getFormatConfiguration() {
            return this.formatConfiguration != null ? this.formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(NumericFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(NumericFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        public ReferenceLineValueLabelConfiguration build() {
            return new ReferenceLineValueLabelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLineValueLabelConfiguration> {
        public Builder relativePosition(String var1);

        public Builder relativePosition(ReferenceLineValueLabelRelativePosition var1);

        public Builder formatConfiguration(NumericFormatConfiguration var1);

        default public Builder formatConfiguration(Consumer<NumericFormatConfiguration.Builder> formatConfiguration) {
            return this.formatConfiguration((NumericFormatConfiguration)((NumericFormatConfiguration.Builder)NumericFormatConfiguration.builder().applyMutation(formatConfiguration)).build());
        }
    }
}

