/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableBorderStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableBorderOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableBorderOptions> {
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(TableBorderOptions.getter(TableBorderOptions::color)).setter(TableBorderOptions.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<Integer> THICKNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Thickness").getter(TableBorderOptions.getter(TableBorderOptions::thickness)).setter(TableBorderOptions.setter(Builder::thickness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thickness").build()}).build();
    private static final SdkField<String> STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Style").getter(TableBorderOptions.getter(TableBorderOptions::styleAsString)).setter(TableBorderOptions.setter(Builder::style)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_FIELD, THICKNESS_FIELD, STYLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Color", COLOR_FIELD);
            this.put("Thickness", THICKNESS_FIELD);
            this.put("Style", STYLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String color;
    private final Integer thickness;
    private final String style;

    private TableBorderOptions(BuilderImpl builder) {
        this.color = builder.color;
        this.thickness = builder.thickness;
        this.style = builder.style;
    }

    public final String color() {
        return this.color;
    }

    public final Integer thickness() {
        return this.thickness;
    }

    public final TableBorderStyle style() {
        return TableBorderStyle.fromValue(this.style);
    }

    public final String styleAsString() {
        return this.style;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.thickness());
        hashCode = 31 * hashCode + Objects.hashCode(this.styleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBorderOptions)) {
            return false;
        }
        TableBorderOptions other = (TableBorderOptions)obj;
        return Objects.equals(this.color(), other.color()) && Objects.equals(this.thickness(), other.thickness()) && Objects.equals(this.styleAsString(), other.styleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TableBorderOptions").add("Color", (Object)this.color()).add("Thickness", (Object)this.thickness()).add("Style", (Object)this.styleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "Thickness": {
                return Optional.ofNullable(clazz.cast(this.thickness()));
            }
            case "Style": {
                return Optional.ofNullable(clazz.cast(this.styleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableBorderOptions, T> g) {
        return obj -> g.apply((TableBorderOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String color;
        private Integer thickness;
        private String style;

        private BuilderImpl() {
        }

        private BuilderImpl(TableBorderOptions model) {
            this.color(model.color);
            this.thickness(model.thickness);
            this.style(model.style);
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final Integer getThickness() {
            return this.thickness;
        }

        public final void setThickness(Integer thickness) {
            this.thickness = thickness;
        }

        @Override
        public final Builder thickness(Integer thickness) {
            this.thickness = thickness;
            return this;
        }

        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(TableBorderStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public TableBorderOptions build() {
            return new TableBorderOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableBorderOptions> {
        public Builder color(String var1);

        public Builder thickness(Integer var1);

        public Builder style(String var1);

        public Builder style(TableBorderStyle var1);
    }
}

