/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnHierarchy;
import software.amazon.awssdk.services.quicksight.model.ColumnHierarchyListCopier;
import software.amazon.awssdk.services.quicksight.model.PieChartConfiguration;
import software.amazon.awssdk.services.quicksight.model.VisualCustomAction;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionListCopier;
import software.amazon.awssdk.services.quicksight.model.VisualSubtitleLabelOptions;
import software.amazon.awssdk.services.quicksight.model.VisualTitleLabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PieChartVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PieChartVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(PieChartVisual.getter(PieChartVisual::visualId)).setter(PieChartVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(PieChartVisual.getter(PieChartVisual::title)).setter(PieChartVisual.setter(Builder::title)).constructor(VisualTitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subtitle").getter(PieChartVisual.getter(PieChartVisual::subtitle)).setter(PieChartVisual.setter(Builder::subtitle)).constructor(VisualSubtitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()}).build();
    private static final SdkField<PieChartConfiguration> CHART_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChartConfiguration").getter(PieChartVisual.getter(PieChartVisual::chartConfiguration)).setter(PieChartVisual.setter(Builder::chartConfiguration)).constructor(PieChartConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build()}).build();
    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(PieChartVisual.getter(PieChartVisual::actions)).setter(PieChartVisual.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ColumnHierarchy>> COLUMN_HIERARCHIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnHierarchies").getter(PieChartVisual.getter(PieChartVisual::columnHierarchies)).setter(PieChartVisual.setter(Builder::columnHierarchies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnHierarchies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, TITLE_FIELD, SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, ACTIONS_FIELD, COLUMN_HIERARCHIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VisualId", VISUAL_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Subtitle", SUBTITLE_FIELD);
            this.put("ChartConfiguration", CHART_CONFIGURATION_FIELD);
            this.put("Actions", ACTIONS_FIELD);
            this.put("ColumnHierarchies", COLUMN_HIERARCHIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final VisualTitleLabelOptions title;
    private final VisualSubtitleLabelOptions subtitle;
    private final PieChartConfiguration chartConfiguration;
    private final List<VisualCustomAction> actions;
    private final List<ColumnHierarchy> columnHierarchies;

    private PieChartVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.actions = builder.actions;
        this.columnHierarchies = builder.columnHierarchies;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final VisualTitleLabelOptions title() {
        return this.title;
    }

    public final VisualSubtitleLabelOptions subtitle() {
        return this.subtitle;
    }

    public final PieChartConfiguration chartConfiguration() {
        return this.chartConfiguration;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<VisualCustomAction> actions() {
        return this.actions;
    }

    public final boolean hasColumnHierarchies() {
        return this.columnHierarchies != null && !(this.columnHierarchies instanceof SdkAutoConstructList);
    }

    public final List<ColumnHierarchy> columnHierarchies() {
        return this.columnHierarchies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnHierarchies() ? this.columnHierarchies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PieChartVisual)) {
            return false;
        }
        PieChartVisual other = (PieChartVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.chartConfiguration(), other.chartConfiguration()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasColumnHierarchies() == other.hasColumnHierarchies() && Objects.equals(this.columnHierarchies(), other.columnHierarchies());
    }

    public final String toString() {
        return ToString.builder((String)"PieChartVisual").add("VisualId", (Object)this.visualId()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("ChartConfiguration", (Object)this.chartConfiguration()).add("Actions", this.hasActions() ? this.actions() : null).add("ColumnHierarchies", this.hasColumnHierarchies() ? this.columnHierarchies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "ChartConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chartConfiguration()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "ColumnHierarchies": {
                return Optional.ofNullable(clazz.cast(this.columnHierarchies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PieChartVisual, T> g) {
        return obj -> g.apply((PieChartVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private VisualTitleLabelOptions title;
        private VisualSubtitleLabelOptions subtitle;
        private PieChartConfiguration chartConfiguration;
        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<ColumnHierarchy> columnHierarchies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PieChartVisual model) {
            this.visualId(model.visualId);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.chartConfiguration(model.chartConfiguration);
            this.actions(model.actions);
            this.columnHierarchies(model.columnHierarchies);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return this.subtitle != null ? this.subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final PieChartConfiguration.Builder getChartConfiguration() {
            return this.chartConfiguration != null ? this.chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(PieChartConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(PieChartConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VisualCustomAction)((VisualCustomAction.Builder)VisualCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnHierarchy.Builder> getColumnHierarchies() {
            List<ColumnHierarchy.Builder> result = ColumnHierarchyListCopier.copyToBuilder(this.columnHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnHierarchies(Collection<ColumnHierarchy.BuilderImpl> columnHierarchies) {
            this.columnHierarchies = ColumnHierarchyListCopier.copyFromBuilder(columnHierarchies);
        }

        @Override
        public final Builder columnHierarchies(Collection<ColumnHierarchy> columnHierarchies) {
            this.columnHierarchies = ColumnHierarchyListCopier.copy(columnHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnHierarchies(ColumnHierarchy ... columnHierarchies) {
            this.columnHierarchies(Arrays.asList(columnHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnHierarchies(Consumer<ColumnHierarchy.Builder> ... columnHierarchies) {
            this.columnHierarchies(Stream.of(columnHierarchies).map(c -> (ColumnHierarchy)((ColumnHierarchy.Builder)ColumnHierarchy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PieChartVisual build() {
            return new PieChartVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PieChartVisual> {
        public Builder visualId(String var1);

        public Builder title(VisualTitleLabelOptions var1);

        default public Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return this.title((VisualTitleLabelOptions)((VisualTitleLabelOptions.Builder)VisualTitleLabelOptions.builder().applyMutation(title)).build());
        }

        public Builder subtitle(VisualSubtitleLabelOptions var1);

        default public Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return this.subtitle((VisualSubtitleLabelOptions)((VisualSubtitleLabelOptions.Builder)VisualSubtitleLabelOptions.builder().applyMutation(subtitle)).build());
        }

        public Builder chartConfiguration(PieChartConfiguration var1);

        default public Builder chartConfiguration(Consumer<PieChartConfiguration.Builder> chartConfiguration) {
            return this.chartConfiguration((PieChartConfiguration)((PieChartConfiguration.Builder)PieChartConfiguration.builder().applyMutation(chartConfiguration)).build());
        }

        public Builder actions(Collection<VisualCustomAction> var1);

        public Builder actions(VisualCustomAction ... var1);

        public Builder actions(Consumer<VisualCustomAction.Builder> ... var1);

        public Builder columnHierarchies(Collection<ColumnHierarchy> var1);

        public Builder columnHierarchies(ColumnHierarchy ... var1);

        public Builder columnHierarchies(Consumer<ColumnHierarchy.Builder> ... var1);
    }
}

