/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePermission> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Principal").getter(ResourcePermission.getter(ResourcePermission::principal)).setter(ResourcePermission.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(ResourcePermission.getter(ResourcePermission::actions)).setter(ResourcePermission.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Principal", PRINCIPAL_FIELD);
            this.put("Actions", ACTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String principal;
    private final List<String> actions;

    private ResourcePermission(BuilderImpl builder) {
        this.principal = builder.principal;
        this.actions = builder.actions;
    }

    public final String principal() {
        return this.principal;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePermission)) {
            return false;
        }
        ResourcePermission other = (ResourcePermission)obj;
        return Objects.equals(this.principal(), other.principal()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePermission").add("Principal", (Object)this.principal()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePermission, T> g) {
        return obj -> g.apply((ResourcePermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String principal;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePermission model) {
            this.principal(model.principal);
            this.actions(model.actions);
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public ResourcePermission build() {
            return new ResourcePermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePermission> {
        public Builder principal(String var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);
    }
}

