/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A customer managed key structure that contains the information listed below:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>KeyArn</code> - The ARN of a KMS key that is registered to a Amazon QuickSight account for encryption and
 * decryption use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DefaultKey</code> - Indicates whether the current key is set as the default key for encryption and decryption
 * use.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredCustomerManagedKey implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredCustomerManagedKey.Builder, RegisteredCustomerManagedKey> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(RegisteredCustomerManagedKey::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<Boolean> DEFAULT_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultKey").getter(getter(RegisteredCustomerManagedKey::defaultKey))
            .setter(setter(Builder::defaultKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD,
            DEFAULT_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyArn;

    private final Boolean defaultKey;

    private RegisteredCustomerManagedKey(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.defaultKey = builder.defaultKey;
    }

    /**
     * <p>
     * The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.
     * </p>
     * 
     * @return The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption
     *         use.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * Indicates whether a <code>RegisteredCustomerManagedKey</code> is set as the default key for encryption and
     * decryption use.
     * </p>
     * 
     * @return Indicates whether a <code>RegisteredCustomerManagedKey</code> is set as the default key for encryption
     *         and decryption use.
     */
    public final Boolean defaultKey() {
        return defaultKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredCustomerManagedKey)) {
            return false;
        }
        RegisteredCustomerManagedKey other = (RegisteredCustomerManagedKey) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(defaultKey(), other.defaultKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredCustomerManagedKey").add("KeyArn", keyArn()).add("DefaultKey", defaultKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "DefaultKey":
            return Optional.ofNullable(clazz.cast(defaultKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredCustomerManagedKey, T> g) {
        return obj -> g.apply((RegisteredCustomerManagedKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredCustomerManagedKey> {
        /**
         * <p>
         * The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption use.
         * </p>
         * 
         * @param keyArn
         *        The ARN of the KMS key that is registered to a Amazon QuickSight account for encryption and decryption
         *        use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * Indicates whether a <code>RegisteredCustomerManagedKey</code> is set as the default key for encryption and
         * decryption use.
         * </p>
         * 
         * @param defaultKey
         *        Indicates whether a <code>RegisteredCustomerManagedKey</code> is set as the default key for encryption
         *        and decryption use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultKey(Boolean defaultKey);
    }

    static final class BuilderImpl implements Builder {
        private String keyArn;

        private Boolean defaultKey;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredCustomerManagedKey model) {
            keyArn(model.keyArn);
            defaultKey(model.defaultKey);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final Boolean getDefaultKey() {
            return defaultKey;
        }

        public final void setDefaultKey(Boolean defaultKey) {
            this.defaultKey = defaultKey;
        }

        @Override
        public final Builder defaultKey(Boolean defaultKey) {
            this.defaultKey = defaultKey;
            return this;
        }

        @Override
        public RegisteredCustomerManagedKey build() {
            return new RegisteredCustomerManagedKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
