/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a named entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamedEntityDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<NamedEntityDefinition.Builder, NamedEntityDefinition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(NamedEntityDefinition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyName").getter(getter(NamedEntityDefinition::propertyName)).setter(setter(Builder::propertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyName").build()).build();

    private static final SdkField<String> PROPERTY_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyRole").getter(getter(NamedEntityDefinition::propertyRoleAsString))
            .setter(setter(Builder::propertyRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyRole").build()).build();

    private static final SdkField<String> PROPERTY_USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyUsage").getter(getter(NamedEntityDefinition::propertyUsageAsString))
            .setter(setter(Builder::propertyUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyUsage").build()).build();

    private static final SdkField<NamedEntityDefinitionMetric> METRIC_FIELD = SdkField
            .<NamedEntityDefinitionMetric> builder(MarshallingType.SDK_POJO).memberName("Metric")
            .getter(getter(NamedEntityDefinition::metric)).setter(setter(Builder::metric))
            .constructor(NamedEntityDefinitionMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            PROPERTY_NAME_FIELD, PROPERTY_ROLE_FIELD, PROPERTY_USAGE_FIELD, METRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String propertyName;

    private final String propertyRole;

    private final String propertyUsage;

    private final NamedEntityDefinitionMetric metric;

    private NamedEntityDefinition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.propertyName = builder.propertyName;
        this.propertyRole = builder.propertyRole;
        this.propertyUsage = builder.propertyUsage;
        this.metric = builder.metric;
    }

    /**
     * <p>
     * The name of the entity.
     * </p>
     * 
     * @return The name of the entity.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The property name to be used for the named entity.
     * </p>
     * 
     * @return The property name to be used for the named entity.
     */
    public final String propertyName() {
        return propertyName;
    }

    /**
     * <p>
     * The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyRole} will
     * return {@link PropertyRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyRoleAsString}.
     * </p>
     * 
     * @return The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
     * @see PropertyRole
     */
    public final PropertyRole propertyRole() {
        return PropertyRole.fromValue(propertyRole);
    }

    /**
     * <p>
     * The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyRole} will
     * return {@link PropertyRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyRoleAsString}.
     * </p>
     * 
     * @return The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
     * @see PropertyRole
     */
    public final String propertyRoleAsString() {
        return propertyRole;
    }

    /**
     * <p>
     * The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
     * <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyUsage}
     * will return {@link PropertyUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyUsageAsString}.
     * </p>
     * 
     * @return The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
     *         <code>MEASURE</code>.
     * @see PropertyUsage
     */
    public final PropertyUsage propertyUsage() {
        return PropertyUsage.fromValue(propertyUsage);
    }

    /**
     * <p>
     * The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
     * <code>MEASURE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propertyUsage}
     * will return {@link PropertyUsage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propertyUsageAsString}.
     * </p>
     * 
     * @return The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
     *         <code>MEASURE</code>.
     * @see PropertyUsage
     */
    public final String propertyUsageAsString() {
        return propertyUsage;
    }

    /**
     * <p>
     * The definition of a metric.
     * </p>
     * 
     * @return The definition of a metric.
     */
    public final NamedEntityDefinitionMetric metric() {
        return metric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(propertyName());
        hashCode = 31 * hashCode + Objects.hashCode(propertyRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(propertyUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedEntityDefinition)) {
            return false;
        }
        NamedEntityDefinition other = (NamedEntityDefinition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(propertyName(), other.propertyName())
                && Objects.equals(propertyRoleAsString(), other.propertyRoleAsString())
                && Objects.equals(propertyUsageAsString(), other.propertyUsageAsString())
                && Objects.equals(metric(), other.metric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NamedEntityDefinition").add("FieldName", fieldName()).add("PropertyName", propertyName())
                .add("PropertyRole", propertyRoleAsString()).add("PropertyUsage", propertyUsageAsString())
                .add("Metric", metric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "PropertyName":
            return Optional.ofNullable(clazz.cast(propertyName()));
        case "PropertyRole":
            return Optional.ofNullable(clazz.cast(propertyRoleAsString()));
        case "PropertyUsage":
            return Optional.ofNullable(clazz.cast(propertyUsageAsString()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamedEntityDefinition, T> g) {
        return obj -> g.apply((NamedEntityDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamedEntityDefinition> {
        /**
         * <p>
         * The name of the entity.
         * </p>
         * 
         * @param fieldName
         *        The name of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The property name to be used for the named entity.
         * </p>
         * 
         * @param propertyName
         *        The property name to be used for the named entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyName(String propertyName);

        /**
         * <p>
         * The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
         * </p>
         * 
         * @param propertyRole
         *        The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
         * @see PropertyRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyRole
         */
        Builder propertyRole(String propertyRole);

        /**
         * <p>
         * The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
         * </p>
         * 
         * @param propertyRole
         *        The property role. Valid values for this structure are <code>PRIMARY</code> and <code>ID</code>.
         * @see PropertyRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyRole
         */
        Builder propertyRole(PropertyRole propertyRole);

        /**
         * <p>
         * The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
         * <code>MEASURE</code>.
         * </p>
         * 
         * @param propertyUsage
         *        The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>,
         *        and <code>MEASURE</code>.
         * @see PropertyUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyUsage
         */
        Builder propertyUsage(String propertyUsage);

        /**
         * <p>
         * The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>, and
         * <code>MEASURE</code>.
         * </p>
         * 
         * @param propertyUsage
         *        The property usage. Valid values for this structure are <code>INHERIT</code>, <code>DIMENSION</code>,
         *        and <code>MEASURE</code>.
         * @see PropertyUsage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyUsage
         */
        Builder propertyUsage(PropertyUsage propertyUsage);

        /**
         * <p>
         * The definition of a metric.
         * </p>
         * 
         * @param metric
         *        The definition of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(NamedEntityDefinitionMetric metric);

        /**
         * <p>
         * The definition of a metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamedEntityDefinitionMetric.Builder}
         * avoiding the need to create one manually via {@link NamedEntityDefinitionMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamedEntityDefinitionMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #metric(NamedEntityDefinitionMetric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link NamedEntityDefinitionMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(NamedEntityDefinitionMetric)
         */
        default Builder metric(Consumer<NamedEntityDefinitionMetric.Builder> metric) {
            return metric(NamedEntityDefinitionMetric.builder().applyMutation(metric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String propertyName;

        private String propertyRole;

        private String propertyUsage;

        private NamedEntityDefinitionMetric metric;

        private BuilderImpl() {
        }

        private BuilderImpl(NamedEntityDefinition model) {
            fieldName(model.fieldName);
            propertyName(model.propertyName);
            propertyRole(model.propertyRole);
            propertyUsage(model.propertyUsage);
            metric(model.metric);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getPropertyName() {
            return propertyName;
        }

        public final void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public final Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public final String getPropertyRole() {
            return propertyRole;
        }

        public final void setPropertyRole(String propertyRole) {
            this.propertyRole = propertyRole;
        }

        @Override
        public final Builder propertyRole(String propertyRole) {
            this.propertyRole = propertyRole;
            return this;
        }

        @Override
        public final Builder propertyRole(PropertyRole propertyRole) {
            this.propertyRole(propertyRole == null ? null : propertyRole.toString());
            return this;
        }

        public final String getPropertyUsage() {
            return propertyUsage;
        }

        public final void setPropertyUsage(String propertyUsage) {
            this.propertyUsage = propertyUsage;
        }

        @Override
        public final Builder propertyUsage(String propertyUsage) {
            this.propertyUsage = propertyUsage;
            return this;
        }

        @Override
        public final Builder propertyUsage(PropertyUsage propertyUsage) {
            this.propertyUsage(propertyUsage == null ? null : propertyUsage.toString());
            return this;
        }

        public final NamedEntityDefinitionMetric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(NamedEntityDefinitionMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(NamedEntityDefinitionMetric metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public NamedEntityDefinition build() {
            return new NamedEntityDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
