/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DatasetParameterValueType;
import software.amazon.awssdk.services.quicksight.model.IntegerDatasetParameterDefaultValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerDatasetParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegerDatasetParameter> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(IntegerDatasetParameter.getter(IntegerDatasetParameter::id)).setter(IntegerDatasetParameter.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(IntegerDatasetParameter.getter(IntegerDatasetParameter::name)).setter(IntegerDatasetParameter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(IntegerDatasetParameter.getter(IntegerDatasetParameter::valueTypeAsString)).setter(IntegerDatasetParameter.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<IntegerDatasetParameterDefaultValues> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValues").getter(IntegerDatasetParameter.getter(IntegerDatasetParameter::defaultValues)).setter(IntegerDatasetParameter.setter(Builder::defaultValues)).constructor(IntegerDatasetParameterDefaultValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, VALUE_TYPE_FIELD, DEFAULT_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String valueType;
    private final IntegerDatasetParameterDefaultValues defaultValues;

    private IntegerDatasetParameter(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.defaultValues = builder.defaultValues;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final DatasetParameterValueType valueType() {
        return DatasetParameterValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final IntegerDatasetParameterDefaultValues defaultValues() {
        return this.defaultValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerDatasetParameter)) {
            return false;
        }
        IntegerDatasetParameter other = (IntegerDatasetParameter)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.defaultValues(), other.defaultValues());
    }

    public final String toString() {
        return ToString.builder((String)"IntegerDatasetParameter").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ValueType", (Object)this.valueTypeAsString()).add("DefaultValues", (Object)this.defaultValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegerDatasetParameter, T> g) {
        return obj -> g.apply((IntegerDatasetParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String valueType;
        private IntegerDatasetParameterDefaultValues defaultValues;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerDatasetParameter model) {
            this.id(model.id);
            this.name(model.name);
            this.valueType(model.valueType);
            this.defaultValues(model.defaultValues);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DatasetParameterValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final IntegerDatasetParameterDefaultValues.Builder getDefaultValues() {
            return this.defaultValues != null ? this.defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(IntegerDatasetParameterDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(IntegerDatasetParameterDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public IntegerDatasetParameter build() {
            return new IntegerDatasetParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegerDatasetParameter> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DatasetParameterValueType var1);

        public Builder defaultValues(IntegerDatasetParameterDefaultValues var1);

        default public Builder defaultValues(Consumer<IntegerDatasetParameterDefaultValues.Builder> defaultValues) {
            return this.defaultValues((IntegerDatasetParameterDefaultValues)((IntegerDatasetParameterDefaultValues.Builder)IntegerDatasetParameterDefaultValues.builder().applyMutation(defaultValues)).build());
        }
    }
}

