/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisBinding;
import software.amazon.awssdk.services.quicksight.model.LineChartSeriesSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldSeriesItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldSeriesItem> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(FieldSeriesItem.getter(FieldSeriesItem::fieldId)).setter(FieldSeriesItem.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisBinding").getter(FieldSeriesItem.getter(FieldSeriesItem::axisBindingAsString)).setter(FieldSeriesItem.setter(Builder::axisBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()}).build();
    private static final SdkField<LineChartSeriesSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(FieldSeriesItem.getter(FieldSeriesItem::settings)).setter(FieldSeriesItem.setter(Builder::settings)).constructor(LineChartSeriesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, AXIS_BINDING_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String axisBinding;
    private final LineChartSeriesSettings settings;

    private FieldSeriesItem(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.axisBinding = builder.axisBinding;
        this.settings = builder.settings;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(this.axisBinding);
    }

    public final String axisBindingAsString() {
        return this.axisBinding;
    }

    public final LineChartSeriesSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisBindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSeriesItem)) {
            return false;
        }
        FieldSeriesItem other = (FieldSeriesItem)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.axisBindingAsString(), other.axisBindingAsString()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"FieldSeriesItem").add("FieldId", (Object)this.fieldId()).add("AxisBinding", (Object)this.axisBindingAsString()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "AxisBinding": {
                return Optional.ofNullable(clazz.cast(this.axisBindingAsString()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldSeriesItem, T> g) {
        return obj -> g.apply((FieldSeriesItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String axisBinding;
        private LineChartSeriesSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSeriesItem model) {
            this.fieldId(model.fieldId);
            this.axisBinding(model.axisBinding);
            this.settings(model.settings);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getAxisBinding() {
            return this.axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        public final LineChartSeriesSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(LineChartSeriesSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(LineChartSeriesSettings settings) {
            this.settings = settings;
            return this;
        }

        public FieldSeriesItem build() {
            return new FieldSeriesItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldSeriesItem> {
        public Builder fieldId(String var1);

        public Builder axisBinding(String var1);

        public Builder axisBinding(AxisBinding var1);

        public Builder settings(LineChartSeriesSettings var1);

        default public Builder settings(Consumer<LineChartSeriesSettings.Builder> settings) {
            return this.settings((LineChartSeriesSettings)((LineChartSeriesSettings.Builder)LineChartSeriesSettings.builder().applyMutation(settings)).build());
        }
    }
}

