/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfaceStatus {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    CREATION_FAILED("CREATION_FAILED"),
    UPDATING("UPDATING"),
    UPDATE_FAILED("UPDATE_FAILED"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    DELETION_FAILED("DELETION_FAILED"),
    DELETION_SCHEDULED("DELETION_SCHEDULED"),
    ATTACHMENT_FAILED_ROLLBACK_FAILED("ATTACHMENT_FAILED_ROLLBACK_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceStatus> VALUE_MAP;
    private final String value;

    private NetworkInterfaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceStatus> knownValues() {
        EnumSet<NetworkInterfaceStatus> knownValues = EnumSet.allOf(NetworkInterfaceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceStatus.class, NetworkInterfaceStatus::toString);
    }
}

