/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom action defined on a visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualCustomAction implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualCustomAction.Builder, VisualCustomAction> {
    private static final SdkField<String> CUSTOM_ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomActionId").getter(getter(VisualCustomAction::customActionId))
            .setter(setter(Builder::customActionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VisualCustomAction::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(VisualCustomAction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TRIGGER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Trigger")
            .getter(getter(VisualCustomAction::triggerAsString)).setter(setter(Builder::trigger))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()).build();

    private static final SdkField<List<VisualCustomActionOperation>> ACTION_OPERATIONS_FIELD = SdkField
            .<List<VisualCustomActionOperation>> builder(MarshallingType.LIST)
            .memberName("ActionOperations")
            .getter(getter(VisualCustomAction::actionOperations))
            .setter(setter(Builder::actionOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VisualCustomActionOperation> builder(MarshallingType.SDK_POJO)
                                            .constructor(VisualCustomActionOperation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_ID_FIELD,
            NAME_FIELD, STATUS_FIELD, TRIGGER_FIELD, ACTION_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String customActionId;

    private final String name;

    private final String status;

    private final String trigger;

    private final List<VisualCustomActionOperation> actionOperations;

    private VisualCustomAction(BuilderImpl builder) {
        this.customActionId = builder.customActionId;
        this.name = builder.name;
        this.status = builder.status;
        this.trigger = builder.trigger;
        this.actionOperations = builder.actionOperations;
    }

    /**
     * <p>
     * The ID of the <code>VisualCustomAction</code>.
     * </p>
     * 
     * @return The ID of the <code>VisualCustomAction</code>.
     */
    public final String customActionId() {
        return customActionId;
    }

    /**
     * <p>
     * The name of the <code>VisualCustomAction</code>.
     * </p>
     * 
     * @return The name of the <code>VisualCustomAction</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the <code>VisualCustomAction</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>VisualCustomAction</code>.
     * @see WidgetStatus
     */
    public final WidgetStatus status() {
        return WidgetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the <code>VisualCustomAction</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WidgetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the <code>VisualCustomAction</code>.
     * @see WidgetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The trigger of the <code>VisualCustomAction</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trigger} will
     * return {@link VisualCustomActionTrigger#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #triggerAsString}.
     * </p>
     * 
     * @return The trigger of the <code>VisualCustomAction</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
     *         </p>
     *         </li>
     * @see VisualCustomActionTrigger
     */
    public final VisualCustomActionTrigger trigger() {
        return VisualCustomActionTrigger.fromValue(trigger);
    }

    /**
     * <p>
     * The trigger of the <code>VisualCustomAction</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trigger} will
     * return {@link VisualCustomActionTrigger#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #triggerAsString}.
     * </p>
     * 
     * @return The trigger of the <code>VisualCustomAction</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
     *         </p>
     *         </li>
     * @see VisualCustomActionTrigger
     */
    public final String triggerAsString() {
        return trigger;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionOperations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionOperations() {
        return actionOperations != null && !(actionOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>VisualCustomActionOperations</code>.
     * </p>
     * <p>
     * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionOperations} method.
     * </p>
     * 
     * @return A list of <code>VisualCustomActionOperations</code>.</p>
     *         <p>
     *         This is a union type structure. For this structure to be valid, only one of the attributes can be
     *         defined.
     */
    public final List<VisualCustomActionOperation> actionOperations() {
        return actionOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customActionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(triggerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionOperations() ? actionOperations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualCustomAction)) {
            return false;
        }
        VisualCustomAction other = (VisualCustomAction) obj;
        return Objects.equals(customActionId(), other.customActionId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(triggerAsString(), other.triggerAsString())
                && hasActionOperations() == other.hasActionOperations()
                && Objects.equals(actionOperations(), other.actionOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualCustomAction").add("CustomActionId", customActionId()).add("Name", name())
                .add("Status", statusAsString()).add("Trigger", triggerAsString())
                .add("ActionOperations", hasActionOperations() ? actionOperations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomActionId":
            return Optional.ofNullable(clazz.cast(customActionId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Trigger":
            return Optional.ofNullable(clazz.cast(triggerAsString()));
        case "ActionOperations":
            return Optional.ofNullable(clazz.cast(actionOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VisualCustomAction, T> g) {
        return obj -> g.apply((VisualCustomAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualCustomAction> {
        /**
         * <p>
         * The ID of the <code>VisualCustomAction</code>.
         * </p>
         * 
         * @param customActionId
         *        The ID of the <code>VisualCustomAction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionId(String customActionId);

        /**
         * <p>
         * The name of the <code>VisualCustomAction</code>.
         * </p>
         * 
         * @param name
         *        The name of the <code>VisualCustomAction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the <code>VisualCustomAction</code>.
         * </p>
         * 
         * @param status
         *        The status of the <code>VisualCustomAction</code>.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the <code>VisualCustomAction</code>.
         * </p>
         * 
         * @param status
         *        The status of the <code>VisualCustomAction</code>.
         * @see WidgetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WidgetStatus
         */
        Builder status(WidgetStatus status);

        /**
         * <p>
         * The trigger of the <code>VisualCustomAction</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trigger
         *        The trigger of the <code>VisualCustomAction</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
         *        </p>
         *        </li>
         * @see VisualCustomActionTrigger
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualCustomActionTrigger
         */
        Builder trigger(String trigger);

        /**
         * <p>
         * The trigger of the <code>VisualCustomAction</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trigger
         *        The trigger of the <code>VisualCustomAction</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DATA_POINT_CLICK</code>: Initiates a custom action by a left pointer click on a data point.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DATA_POINT_MENU</code>: Initiates a custom action by right pointer click from the menu.
         *        </p>
         *        </li>
         * @see VisualCustomActionTrigger
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualCustomActionTrigger
         */
        Builder trigger(VisualCustomActionTrigger trigger);

        /**
         * <p>
         * A list of <code>VisualCustomActionOperations</code>.
         * </p>
         * <p>
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         * </p>
         * 
         * @param actionOperations
         *        A list of <code>VisualCustomActionOperations</code>.</p>
         *        <p>
         *        This is a union type structure. For this structure to be valid, only one of the attributes can be
         *        defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionOperations(Collection<VisualCustomActionOperation> actionOperations);

        /**
         * <p>
         * A list of <code>VisualCustomActionOperations</code>.
         * </p>
         * <p>
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         * </p>
         * 
         * @param actionOperations
         *        A list of <code>VisualCustomActionOperations</code>.</p>
         *        <p>
         *        This is a union type structure. For this structure to be valid, only one of the attributes can be
         *        defined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionOperations(VisualCustomActionOperation... actionOperations);

        /**
         * <p>
         * A list of <code>VisualCustomActionOperations</code>.
         * </p>
         * <p>
         * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperation.Builder#build()} is
         * called immediately and its result is passed to {@link #actionOperations(List<VisualCustomActionOperation>)}.
         * 
         * @param actionOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.VisualCustomActionOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionOperations(java.util.Collection<VisualCustomActionOperation>)
         */
        Builder actionOperations(Consumer<VisualCustomActionOperation.Builder>... actionOperations);
    }

    static final class BuilderImpl implements Builder {
        private String customActionId;

        private String name;

        private String status;

        private String trigger;

        private List<VisualCustomActionOperation> actionOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VisualCustomAction model) {
            customActionId(model.customActionId);
            name(model.name);
            status(model.status);
            trigger(model.trigger);
            actionOperations(model.actionOperations);
        }

        public final String getCustomActionId() {
            return customActionId;
        }

        public final void setCustomActionId(String customActionId) {
            this.customActionId = customActionId;
        }

        @Override
        public final Builder customActionId(String customActionId) {
            this.customActionId = customActionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrigger() {
            return trigger;
        }

        public final void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        @Override
        public final Builder trigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public final Builder trigger(VisualCustomActionTrigger trigger) {
            this.trigger(trigger == null ? null : trigger.toString());
            return this;
        }

        public final List<VisualCustomActionOperation.Builder> getActionOperations() {
            List<VisualCustomActionOperation.Builder> result = VisualCustomActionOperationListCopier
                    .copyToBuilder(this.actionOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionOperations(Collection<VisualCustomActionOperation.BuilderImpl> actionOperations) {
            this.actionOperations = VisualCustomActionOperationListCopier.copyFromBuilder(actionOperations);
        }

        @Override
        public final Builder actionOperations(Collection<VisualCustomActionOperation> actionOperations) {
            this.actionOperations = VisualCustomActionOperationListCopier.copy(actionOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionOperations(VisualCustomActionOperation... actionOperations) {
            actionOperations(Arrays.asList(actionOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionOperations(Consumer<VisualCustomActionOperation.Builder>... actionOperations) {
            actionOperations(Stream.of(actionOperations).map(c -> VisualCustomActionOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VisualCustomAction build() {
            return new VisualCustomAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
