/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a negative format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NegativeFormat implements SdkPojo, Serializable, ToCopyableBuilder<NegativeFormat.Builder, NegativeFormat> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(NegativeFormat::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Suffix")
            .getter(getter(NegativeFormat::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, SUFFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final String suffix;

    private NegativeFormat(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
    }

    /**
     * <p>
     * The prefix for a negative format.
     * </p>
     * 
     * @return The prefix for a negative format.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The suffix for a negative format.
     * </p>
     * 
     * @return The suffix for a negative format.
     */
    public final String suffix() {
        return suffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeFormat)) {
            return false;
        }
        NegativeFormat other = (NegativeFormat) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(suffix(), other.suffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NegativeFormat").add("Prefix", prefix()).add("Suffix", suffix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NegativeFormat, T> g) {
        return obj -> g.apply((NegativeFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NegativeFormat> {
        /**
         * <p>
         * The prefix for a negative format.
         * </p>
         * 
         * @param prefix
         *        The prefix for a negative format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The suffix for a negative format.
         * </p>
         * 
         * @param suffix
         *        The suffix for a negative format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private String suffix;

        private BuilderImpl() {
        }

        private BuilderImpl(NegativeFormat model) {
            prefix(model.prefix);
            suffix(model.suffix);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        public NegativeFormat build() {
            return new NegativeFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
