/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of filter configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterListConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterListConfiguration.Builder, FilterListConfiguration> {
    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchOperator").getter(getter(FilterListConfiguration::matchOperatorAsString))
            .setter(setter(Builder::matchOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()).build();

    private static final SdkField<List<String>> CATEGORY_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CategoryValues")
            .getter(getter(FilterListConfiguration::categoryValues))
            .setter(setter(Builder::categoryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectAllOptions").getter(getter(FilterListConfiguration::selectAllOptionsAsString))
            .setter(setter(Builder::selectAllOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()).build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(FilterListConfiguration::nullOptionAsString))
            .setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_OPERATOR_FIELD,
            CATEGORY_VALUES_FIELD, SELECT_ALL_OPTIONS_FIELD, NULL_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String matchOperator;

    private final List<String> categoryValues;

    private final String selectAllOptions;

    private final String nullOption;

    private FilterListConfiguration(BuilderImpl builder) {
        this.matchOperator = builder.matchOperator;
        this.categoryValues = builder.categoryValues;
        this.selectAllOptions = builder.selectAllOptions;
        this.nullOption = builder.nullOption;
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link CategoryFilterMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see CategoryFilterMatchOperator
     */
    public final CategoryFilterMatchOperator matchOperator() {
        return CategoryFilterMatchOperator.fromValue(matchOperator);
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link CategoryFilterMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see CategoryFilterMatchOperator
     */
    public final String matchOperatorAsString() {
        return matchOperator;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCategoryValues() {
        return categoryValues != null && !(categoryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of category values for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoryValues} method.
     * </p>
     * 
     * @return The list of category values for the filter.
     */
    public final List<String> categoryValues() {
        return categoryValues;
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link CategoryFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see CategoryFilterSelectAllOptions
     */
    public final CategoryFilterSelectAllOptions selectAllOptions() {
        return CategoryFilterSelectAllOptions.fromValue(selectAllOptions);
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link CategoryFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see CategoryFilterSelectAllOptions
     */
    public final String selectAllOptionsAsString() {
        return selectAllOptions;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoryValues() ? categoryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterListConfiguration)) {
            return false;
        }
        FilterListConfiguration other = (FilterListConfiguration) obj;
        return Objects.equals(matchOperatorAsString(), other.matchOperatorAsString())
                && hasCategoryValues() == other.hasCategoryValues() && Objects.equals(categoryValues(), other.categoryValues())
                && Objects.equals(selectAllOptionsAsString(), other.selectAllOptionsAsString())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterListConfiguration").add("MatchOperator", matchOperatorAsString())
                .add("CategoryValues", hasCategoryValues() ? categoryValues() : null)
                .add("SelectAllOptions", selectAllOptionsAsString()).add("NullOption", nullOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchOperator":
            return Optional.ofNullable(clazz.cast(matchOperatorAsString()));
        case "CategoryValues":
            return Optional.ofNullable(clazz.cast(categoryValues()));
        case "SelectAllOptions":
            return Optional.ofNullable(clazz.cast(selectAllOptionsAsString()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterListConfiguration, T> g) {
        return obj -> g.apply((FilterListConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterListConfiguration> {
        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see CategoryFilterMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterMatchOperator
         */
        Builder matchOperator(String matchOperator);

        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see CategoryFilterMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterMatchOperator
         */
        Builder matchOperator(CategoryFilterMatchOperator matchOperator);

        /**
         * <p>
         * The list of category values for the filter.
         * </p>
         * 
         * @param categoryValues
         *        The list of category values for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryValues(Collection<String> categoryValues);

        /**
         * <p>
         * The list of category values for the filter.
         * </p>
         * 
         * @param categoryValues
         *        The list of category values for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryValues(String... categoryValues);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see CategoryFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterSelectAllOptions
         */
        Builder selectAllOptions(String selectAllOptions);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see CategoryFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterSelectAllOptions
         */
        Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);
    }

    static final class BuilderImpl implements Builder {
        private String matchOperator;

        private List<String> categoryValues = DefaultSdkAutoConstructList.getInstance();

        private String selectAllOptions;

        private String nullOption;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterListConfiguration model) {
            matchOperator(model.matchOperator);
            categoryValues(model.categoryValues);
            selectAllOptions(model.selectAllOptions);
            nullOption(model.nullOption);
        }

        public final String getMatchOperator() {
            return matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(CategoryFilterMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final Collection<String> getCategoryValues() {
            if (categoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return categoryValues;
        }

        public final void setCategoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
        }

        @Override
        public final Builder categoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryValues(String... categoryValues) {
            categoryValues(Arrays.asList(categoryValues));
            return this;
        }

        public final String getSelectAllOptions() {
            return selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        @Override
        public FilterListConfiguration build() {
            return new FilterListConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
