/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DecimalPlacesConfiguration;
import software.amazon.awssdk.services.quicksight.model.NegativeValueConfiguration;
import software.amazon.awssdk.services.quicksight.model.NullValueFormatConfiguration;
import software.amazon.awssdk.services.quicksight.model.NumberScale;
import software.amazon.awssdk.services.quicksight.model.NumericSeparatorConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NumberDisplayFormatConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NumberDisplayFormatConfiguration> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::prefix)).setter(NumberDisplayFormatConfiguration.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Suffix").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::suffix)).setter(NumberDisplayFormatConfiguration.setter(Builder::suffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suffix").build()}).build();
    private static final SdkField<NumericSeparatorConfiguration> SEPARATOR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SeparatorConfiguration").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::separatorConfiguration)).setter(NumberDisplayFormatConfiguration.setter(Builder::separatorConfiguration)).constructor(NumericSeparatorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeparatorConfiguration").build()}).build();
    private static final SdkField<DecimalPlacesConfiguration> DECIMAL_PLACES_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DecimalPlacesConfiguration").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::decimalPlacesConfiguration)).setter(NumberDisplayFormatConfiguration.setter(Builder::decimalPlacesConfiguration)).constructor(DecimalPlacesConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalPlacesConfiguration").build()}).build();
    private static final SdkField<String> NUMBER_SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberScale").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::numberScaleAsString)).setter(NumberDisplayFormatConfiguration.setter(Builder::numberScale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberScale").build()}).build();
    private static final SdkField<NegativeValueConfiguration> NEGATIVE_VALUE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NegativeValueConfiguration").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::negativeValueConfiguration)).setter(NumberDisplayFormatConfiguration.setter(Builder::negativeValueConfiguration)).constructor(NegativeValueConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NegativeValueConfiguration").build()}).build();
    private static final SdkField<NullValueFormatConfiguration> NULL_VALUE_FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullValueFormatConfiguration").getter(NumberDisplayFormatConfiguration.getter(NumberDisplayFormatConfiguration::nullValueFormatConfiguration)).setter(NumberDisplayFormatConfiguration.setter(Builder::nullValueFormatConfiguration)).constructor(NullValueFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueFormatConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, SUFFIX_FIELD, SEPARATOR_CONFIGURATION_FIELD, DECIMAL_PLACES_CONFIGURATION_FIELD, NUMBER_SCALE_FIELD, NEGATIVE_VALUE_CONFIGURATION_FIELD, NULL_VALUE_FORMAT_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final String suffix;
    private final NumericSeparatorConfiguration separatorConfiguration;
    private final DecimalPlacesConfiguration decimalPlacesConfiguration;
    private final String numberScale;
    private final NegativeValueConfiguration negativeValueConfiguration;
    private final NullValueFormatConfiguration nullValueFormatConfiguration;

    private NumberDisplayFormatConfiguration(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.separatorConfiguration = builder.separatorConfiguration;
        this.decimalPlacesConfiguration = builder.decimalPlacesConfiguration;
        this.numberScale = builder.numberScale;
        this.negativeValueConfiguration = builder.negativeValueConfiguration;
        this.nullValueFormatConfiguration = builder.nullValueFormatConfiguration;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String suffix() {
        return this.suffix;
    }

    public final NumericSeparatorConfiguration separatorConfiguration() {
        return this.separatorConfiguration;
    }

    public final DecimalPlacesConfiguration decimalPlacesConfiguration() {
        return this.decimalPlacesConfiguration;
    }

    public final NumberScale numberScale() {
        return NumberScale.fromValue(this.numberScale);
    }

    public final String numberScaleAsString() {
        return this.numberScale;
    }

    public final NegativeValueConfiguration negativeValueConfiguration() {
        return this.negativeValueConfiguration;
    }

    public final NullValueFormatConfiguration nullValueFormatConfiguration() {
        return this.nullValueFormatConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.suffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.separatorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalPlacesConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberScaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.negativeValueConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullValueFormatConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberDisplayFormatConfiguration)) {
            return false;
        }
        NumberDisplayFormatConfiguration other = (NumberDisplayFormatConfiguration)obj;
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.suffix(), other.suffix()) && Objects.equals(this.separatorConfiguration(), other.separatorConfiguration()) && Objects.equals(this.decimalPlacesConfiguration(), other.decimalPlacesConfiguration()) && Objects.equals(this.numberScaleAsString(), other.numberScaleAsString()) && Objects.equals(this.negativeValueConfiguration(), other.negativeValueConfiguration()) && Objects.equals(this.nullValueFormatConfiguration(), other.nullValueFormatConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"NumberDisplayFormatConfiguration").add("Prefix", (Object)(this.prefix() == null ? null : "*** Sensitive Data Redacted ***")).add("Suffix", (Object)(this.suffix() == null ? null : "*** Sensitive Data Redacted ***")).add("SeparatorConfiguration", (Object)this.separatorConfiguration()).add("DecimalPlacesConfiguration", (Object)this.decimalPlacesConfiguration()).add("NumberScale", (Object)this.numberScaleAsString()).add("NegativeValueConfiguration", (Object)this.negativeValueConfiguration()).add("NullValueFormatConfiguration", (Object)this.nullValueFormatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Suffix": {
                return Optional.ofNullable(clazz.cast(this.suffix()));
            }
            case "SeparatorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.separatorConfiguration()));
            }
            case "DecimalPlacesConfiguration": {
                return Optional.ofNullable(clazz.cast(this.decimalPlacesConfiguration()));
            }
            case "NumberScale": {
                return Optional.ofNullable(clazz.cast(this.numberScaleAsString()));
            }
            case "NegativeValueConfiguration": {
                return Optional.ofNullable(clazz.cast(this.negativeValueConfiguration()));
            }
            case "NullValueFormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nullValueFormatConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumberDisplayFormatConfiguration, T> g) {
        return obj -> g.apply((NumberDisplayFormatConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefix;
        private String suffix;
        private NumericSeparatorConfiguration separatorConfiguration;
        private DecimalPlacesConfiguration decimalPlacesConfiguration;
        private String numberScale;
        private NegativeValueConfiguration negativeValueConfiguration;
        private NullValueFormatConfiguration nullValueFormatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberDisplayFormatConfiguration model) {
            this.prefix(model.prefix);
            this.suffix(model.suffix);
            this.separatorConfiguration(model.separatorConfiguration);
            this.decimalPlacesConfiguration(model.decimalPlacesConfiguration);
            this.numberScale(model.numberScale);
            this.negativeValueConfiguration(model.negativeValueConfiguration);
            this.nullValueFormatConfiguration(model.nullValueFormatConfiguration);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getSuffix() {
            return this.suffix;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final NumericSeparatorConfiguration.Builder getSeparatorConfiguration() {
            return this.separatorConfiguration != null ? this.separatorConfiguration.toBuilder() : null;
        }

        public final void setSeparatorConfiguration(NumericSeparatorConfiguration.BuilderImpl separatorConfiguration) {
            this.separatorConfiguration = separatorConfiguration != null ? separatorConfiguration.build() : null;
        }

        @Override
        public final Builder separatorConfiguration(NumericSeparatorConfiguration separatorConfiguration) {
            this.separatorConfiguration = separatorConfiguration;
            return this;
        }

        public final DecimalPlacesConfiguration.Builder getDecimalPlacesConfiguration() {
            return this.decimalPlacesConfiguration != null ? this.decimalPlacesConfiguration.toBuilder() : null;
        }

        public final void setDecimalPlacesConfiguration(DecimalPlacesConfiguration.BuilderImpl decimalPlacesConfiguration) {
            this.decimalPlacesConfiguration = decimalPlacesConfiguration != null ? decimalPlacesConfiguration.build() : null;
        }

        @Override
        public final Builder decimalPlacesConfiguration(DecimalPlacesConfiguration decimalPlacesConfiguration) {
            this.decimalPlacesConfiguration = decimalPlacesConfiguration;
            return this;
        }

        public final String getNumberScale() {
            return this.numberScale;
        }

        public final void setNumberScale(String numberScale) {
            this.numberScale = numberScale;
        }

        @Override
        public final Builder numberScale(String numberScale) {
            this.numberScale = numberScale;
            return this;
        }

        @Override
        public final Builder numberScale(NumberScale numberScale) {
            this.numberScale(numberScale == null ? null : numberScale.toString());
            return this;
        }

        public final NegativeValueConfiguration.Builder getNegativeValueConfiguration() {
            return this.negativeValueConfiguration != null ? this.negativeValueConfiguration.toBuilder() : null;
        }

        public final void setNegativeValueConfiguration(NegativeValueConfiguration.BuilderImpl negativeValueConfiguration) {
            this.negativeValueConfiguration = negativeValueConfiguration != null ? negativeValueConfiguration.build() : null;
        }

        @Override
        public final Builder negativeValueConfiguration(NegativeValueConfiguration negativeValueConfiguration) {
            this.negativeValueConfiguration = negativeValueConfiguration;
            return this;
        }

        public final NullValueFormatConfiguration.Builder getNullValueFormatConfiguration() {
            return this.nullValueFormatConfiguration != null ? this.nullValueFormatConfiguration.toBuilder() : null;
        }

        public final void setNullValueFormatConfiguration(NullValueFormatConfiguration.BuilderImpl nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration != null ? nullValueFormatConfiguration.build() : null;
        }

        @Override
        public final Builder nullValueFormatConfiguration(NullValueFormatConfiguration nullValueFormatConfiguration) {
            this.nullValueFormatConfiguration = nullValueFormatConfiguration;
            return this;
        }

        public NumberDisplayFormatConfiguration build() {
            return new NumberDisplayFormatConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NumberDisplayFormatConfiguration> {
        public Builder prefix(String var1);

        public Builder suffix(String var1);

        public Builder separatorConfiguration(NumericSeparatorConfiguration var1);

        default public Builder separatorConfiguration(Consumer<NumericSeparatorConfiguration.Builder> separatorConfiguration) {
            return this.separatorConfiguration((NumericSeparatorConfiguration)((NumericSeparatorConfiguration.Builder)NumericSeparatorConfiguration.builder().applyMutation(separatorConfiguration)).build());
        }

        public Builder decimalPlacesConfiguration(DecimalPlacesConfiguration var1);

        default public Builder decimalPlacesConfiguration(Consumer<DecimalPlacesConfiguration.Builder> decimalPlacesConfiguration) {
            return this.decimalPlacesConfiguration((DecimalPlacesConfiguration)((DecimalPlacesConfiguration.Builder)DecimalPlacesConfiguration.builder().applyMutation(decimalPlacesConfiguration)).build());
        }

        public Builder numberScale(String var1);

        public Builder numberScale(NumberScale var1);

        public Builder negativeValueConfiguration(NegativeValueConfiguration var1);

        default public Builder negativeValueConfiguration(Consumer<NegativeValueConfiguration.Builder> negativeValueConfiguration) {
            return this.negativeValueConfiguration((NegativeValueConfiguration)((NegativeValueConfiguration.Builder)NegativeValueConfiguration.builder().applyMutation(negativeValueConfiguration)).build());
        }

        public Builder nullValueFormatConfiguration(NullValueFormatConfiguration var1);

        default public Builder nullValueFormatConfiguration(Consumer<NullValueFormatConfiguration.Builder> nullValueFormatConfiguration) {
            return this.nullValueFormatConfiguration((NullValueFormatConfiguration)((NullValueFormatConfiguration.Builder)NullValueFormatConfiguration.builder().applyMutation(nullValueFormatConfiguration)).build());
        }
    }
}

