/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DashboardSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;

public class SearchDashboardsPublisher
implements SdkPublisher<SearchDashboardsResponse> {
    private final QuickSightAsyncClient client;
    private final SearchDashboardsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDashboardsPublisher(QuickSightAsyncClient client, SearchDashboardsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDashboardsPublisher(QuickSightAsyncClient client, SearchDashboardsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDashboardsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDashboardsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DashboardSummary> dashboardSummaryList() {
        Function<SearchDashboardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dashboardSummaryList() != null) {
                return response.dashboardSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchDashboardsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchDashboardsResponseFetcher
    implements AsyncPageFetcher<SearchDashboardsResponse> {
        private SearchDashboardsResponseFetcher() {
        }

        public boolean hasNextPage(SearchDashboardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDashboardsResponse> nextPage(SearchDashboardsResponse previousPage) {
            if (previousPage == null) {
                return SearchDashboardsPublisher.this.client.searchDashboards(SearchDashboardsPublisher.this.firstRequest);
            }
            return SearchDashboardsPublisher.this.client.searchDashboards((SearchDashboardsRequest)((Object)SearchDashboardsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

