/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scope configuration for a <code>FilterGroup</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterScopeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterScopeConfiguration.Builder, FilterScopeConfiguration> {
    private static final SdkField<SelectedSheetsFilterScopeConfiguration> SELECTED_SHEETS_FIELD = SdkField
            .<SelectedSheetsFilterScopeConfiguration> builder(MarshallingType.SDK_POJO).memberName("SelectedSheets")
            .getter(getter(FilterScopeConfiguration::selectedSheets)).setter(setter(Builder::selectedSheets))
            .constructor(SelectedSheetsFilterScopeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSheets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_SHEETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SelectedSheetsFilterScopeConfiguration selectedSheets;

    private FilterScopeConfiguration(BuilderImpl builder) {
        this.selectedSheets = builder.selectedSheets;
    }

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     * 
     * @return The configuration for applying a filter to specific sheets.
     */
    public final SelectedSheetsFilterScopeConfiguration selectedSheets() {
        return selectedSheets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedSheets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterScopeConfiguration)) {
            return false;
        }
        FilterScopeConfiguration other = (FilterScopeConfiguration) obj;
        return Objects.equals(selectedSheets(), other.selectedSheets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterScopeConfiguration").add("SelectedSheets", selectedSheets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedSheets":
            return Optional.ofNullable(clazz.cast(selectedSheets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterScopeConfiguration, T> g) {
        return obj -> g.apply((FilterScopeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterScopeConfiguration> {
        /**
         * <p>
         * The configuration for applying a filter to specific sheets.
         * </p>
         * 
         * @param selectedSheets
         *        The configuration for applying a filter to specific sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets);

        /**
         * <p>
         * The configuration for applying a filter to specific sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelectedSheetsFilterScopeConfiguration.Builder} avoiding the need to create one manually via
         * {@link SelectedSheetsFilterScopeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectedSheetsFilterScopeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #selectedSheets(SelectedSheetsFilterScopeConfiguration)}.
         * 
         * @param selectedSheets
         *        a consumer that will call methods on {@link SelectedSheetsFilterScopeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedSheets(SelectedSheetsFilterScopeConfiguration)
         */
        default Builder selectedSheets(Consumer<SelectedSheetsFilterScopeConfiguration.Builder> selectedSheets) {
            return selectedSheets(SelectedSheetsFilterScopeConfiguration.builder().applyMutation(selectedSheets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SelectedSheetsFilterScopeConfiguration selectedSheets;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterScopeConfiguration model) {
            selectedSheets(model.selectedSheets);
        }

        public final SelectedSheetsFilterScopeConfiguration.Builder getSelectedSheets() {
            return selectedSheets != null ? selectedSheets.toBuilder() : null;
        }

        public final void setSelectedSheets(SelectedSheetsFilterScopeConfiguration.BuilderImpl selectedSheets) {
            this.selectedSheets = selectedSheets != null ? selectedSheets.build() : null;
        }

        @Override
        public final Builder selectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets) {
            this.selectedSheets = selectedSheets;
            return this;
        }

        @Override
        public FilterScopeConfiguration build() {
            return new FilterScopeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
