/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a dropdown list with buttons that are used to select a single value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterDropDownControl implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterDropDownControl.Builder, FilterDropDownControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterControlId").getter(getter(FilterDropDownControl::filterControlId))
            .setter(setter(Builder::filterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(FilterDropDownControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFilterId").getter(getter(FilterDropDownControl::sourceFilterId))
            .setter(setter(Builder::sourceFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()).build();

    private static final SdkField<DropDownControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<DropDownControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(FilterDropDownControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(DropDownControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(FilterDropDownControl::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<FilterSelectableValues> SELECTABLE_VALUES_FIELD = SdkField
            .<FilterSelectableValues> builder(MarshallingType.SDK_POJO).memberName("SelectableValues")
            .getter(getter(FilterDropDownControl::selectableValues)).setter(setter(Builder::selectableValues))
            .constructor(FilterSelectableValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectableValues").build()).build();

    private static final SdkField<CascadingControlConfiguration> CASCADING_CONTROL_CONFIGURATION_FIELD = SdkField
            .<CascadingControlConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CascadingControlConfiguration")
            .getter(getter(FilterDropDownControl::cascadingControlConfiguration))
            .setter(setter(Builder::cascadingControlConfiguration))
            .constructor(CascadingControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CascadingControlConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_FILTER_ID_FIELD, DISPLAY_OPTIONS_FIELD, TYPE_FIELD, SELECTABLE_VALUES_FIELD,
            CASCADING_CONTROL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterControlId;

    private final String title;

    private final String sourceFilterId;

    private final DropDownControlDisplayOptions displayOptions;

    private final String type;

    private final FilterSelectableValues selectableValues;

    private final CascadingControlConfiguration cascadingControlConfiguration;

    private FilterDropDownControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.title = builder.title;
        this.sourceFilterId = builder.sourceFilterId;
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.selectableValues = builder.selectableValues;
        this.cascadingControlConfiguration = builder.cascadingControlConfiguration;
    }

    /**
     * <p>
     * The ID of the <code>FilterDropDownControl</code>.
     * </p>
     * 
     * @return The ID of the <code>FilterDropDownControl</code>.
     */
    public final String filterControlId() {
        return filterControlId;
    }

    /**
     * <p>
     * The title of the <code>FilterDropDownControl</code>.
     * </p>
     * 
     * @return The title of the <code>FilterDropDownControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source filter ID of the <code>FilterDropDownControl</code>.
     * </p>
     * 
     * @return The source filter ID of the <code>FilterDropDownControl</code>.
     */
    public final String sourceFilterId() {
        return sourceFilterId;
    }

    /**
     * <p>
     * The display options of the <code>FilterDropDownControl</code>.
     * </p>
     * 
     * @return The display options of the <code>FilterDropDownControl</code>.
     */
    public final DropDownControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlListType
     */
    public final SheetControlListType type() {
        return SheetControlListType.fromValue(type);
    }

    /**
     * <p>
     * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SheetControlListType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
     *         </p>
     *         </li>
     * @see SheetControlListType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A list of selectable values that are used in a control.
     * </p>
     * 
     * @return A list of selectable values that are used in a control.
     */
    public final FilterSelectableValues selectableValues() {
        return selectableValues;
    }

    /**
     * <p>
     * The values that are displayed in a control can be configured to only show values that are valid based on what's
     * selected in other controls.
     * </p>
     * 
     * @return The values that are displayed in a control can be configured to only show values that are valid based on
     *         what's selected in other controls.
     */
    public final CascadingControlConfiguration cascadingControlConfiguration() {
        return cascadingControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectableValues());
        hashCode = 31 * hashCode + Objects.hashCode(cascadingControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterDropDownControl)) {
            return false;
        }
        FilterDropDownControl other = (FilterDropDownControl) obj;
        return Objects.equals(filterControlId(), other.filterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceFilterId(), other.sourceFilterId())
                && Objects.equals(displayOptions(), other.displayOptions())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(selectableValues(), other.selectableValues())
                && Objects.equals(cascadingControlConfiguration(), other.cascadingControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterDropDownControl").add("FilterControlId", filterControlId()).add("Title", title())
                .add("SourceFilterId", sourceFilterId()).add("DisplayOptions", displayOptions()).add("Type", typeAsString())
                .add("SelectableValues", selectableValues())
                .add("CascadingControlConfiguration", cascadingControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterControlId":
            return Optional.ofNullable(clazz.cast(filterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceFilterId":
            return Optional.ofNullable(clazz.cast(sourceFilterId()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SelectableValues":
            return Optional.ofNullable(clazz.cast(selectableValues()));
        case "CascadingControlConfiguration":
            return Optional.ofNullable(clazz.cast(cascadingControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterDropDownControl, T> g) {
        return obj -> g.apply((FilterDropDownControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterDropDownControl> {
        /**
         * <p>
         * The ID of the <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param filterControlId
         *        The ID of the <code>FilterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControlId(String filterControlId);

        /**
         * <p>
         * The title of the <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>FilterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source filter ID of the <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param sourceFilterId
         *        The source filter ID of the <code>FilterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFilterId(String sourceFilterId);

        /**
         * <p>
         * The display options of the <code>FilterDropDownControl</code>.
         * </p>
         * 
         * @param displayOptions
         *        The display options of the <code>FilterDropDownControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(DropDownControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of the <code>FilterDropDownControl</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropDownControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link DropDownControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropDownControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(DropDownControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link DropDownControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(DropDownControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<DropDownControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(DropDownControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the <code>FilterDropDownControl</code>. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of the <code>FilterDropDownControl</code>. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MULTI_SELECT</code>: The user can select multiple entries from a dropdown menu.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SINGLE_SELECT</code>: The user can select a single entry from a dropdown menu.
         *        </p>
         *        </li>
         * @see SheetControlListType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetControlListType
         */
        Builder type(SheetControlListType type);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * 
         * @param selectableValues
         *        A list of selectable values that are used in a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectableValues(FilterSelectableValues selectableValues);

        /**
         * <p>
         * A list of selectable values that are used in a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterSelectableValues.Builder} avoiding
         * the need to create one manually via {@link FilterSelectableValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterSelectableValues.Builder#build()} is called immediately and
         * its result is passed to {@link #selectableValues(FilterSelectableValues)}.
         * 
         * @param selectableValues
         *        a consumer that will call methods on {@link FilterSelectableValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectableValues(FilterSelectableValues)
         */
        default Builder selectableValues(Consumer<FilterSelectableValues.Builder> selectableValues) {
            return selectableValues(FilterSelectableValues.builder().applyMutation(selectableValues).build());
        }

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * 
         * @param cascadingControlConfiguration
         *        The values that are displayed in a control can be configured to only show values that are valid based
         *        on what's selected in other controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration);

        /**
         * <p>
         * The values that are displayed in a control can be configured to only show values that are valid based on
         * what's selected in other controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link CascadingControlConfiguration.Builder}
         * avoiding the need to create one manually via {@link CascadingControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CascadingControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cascadingControlConfiguration(CascadingControlConfiguration)}.
         * 
         * @param cascadingControlConfiguration
         *        a consumer that will call methods on {@link CascadingControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cascadingControlConfiguration(CascadingControlConfiguration)
         */
        default Builder cascadingControlConfiguration(
                Consumer<CascadingControlConfiguration.Builder> cascadingControlConfiguration) {
            return cascadingControlConfiguration(CascadingControlConfiguration.builder()
                    .applyMutation(cascadingControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterControlId;

        private String title;

        private String sourceFilterId;

        private DropDownControlDisplayOptions displayOptions;

        private String type;

        private FilterSelectableValues selectableValues;

        private CascadingControlConfiguration cascadingControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterDropDownControl model) {
            filterControlId(model.filterControlId);
            title(model.title);
            sourceFilterId(model.sourceFilterId);
            displayOptions(model.displayOptions);
            type(model.type);
            selectableValues(model.selectableValues);
            cascadingControlConfiguration(model.cascadingControlConfiguration);
        }

        public final String getFilterControlId() {
            return filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceFilterId() {
            return sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final DropDownControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(DropDownControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(DropDownControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlListType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FilterSelectableValues.Builder getSelectableValues() {
            return selectableValues != null ? selectableValues.toBuilder() : null;
        }

        public final void setSelectableValues(FilterSelectableValues.BuilderImpl selectableValues) {
            this.selectableValues = selectableValues != null ? selectableValues.build() : null;
        }

        @Override
        public final Builder selectableValues(FilterSelectableValues selectableValues) {
            this.selectableValues = selectableValues;
            return this;
        }

        public final CascadingControlConfiguration.Builder getCascadingControlConfiguration() {
            return cascadingControlConfiguration != null ? cascadingControlConfiguration.toBuilder() : null;
        }

        public final void setCascadingControlConfiguration(CascadingControlConfiguration.BuilderImpl cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration != null ? cascadingControlConfiguration.build()
                    : null;
        }

        @Override
        public final Builder cascadingControlConfiguration(CascadingControlConfiguration cascadingControlConfiguration) {
            this.cascadingControlConfiguration = cascadingControlConfiguration;
            return this;
        }

        @Override
        public FilterDropDownControl build() {
            return new FilterDropDownControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
