/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupSchema;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupSchemaListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetConfiguration> {
    private static final SdkField<String> PLACEHOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Placeholder").getter(DataSetConfiguration.getter(DataSetConfiguration::placeholder)).setter(DataSetConfiguration.setter(Builder::placeholder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placeholder").build()}).build();
    private static final SdkField<DataSetSchema> DATA_SET_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSetSchema").getter(DataSetConfiguration.getter(DataSetConfiguration::dataSetSchema)).setter(DataSetConfiguration.setter(Builder::dataSetSchema)).constructor(DataSetSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetSchema").build()}).build();
    private static final SdkField<List<ColumnGroupSchema>> COLUMN_GROUP_SCHEMA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnGroupSchemaList").getter(DataSetConfiguration.getter(DataSetConfiguration::columnGroupSchemaList)).setter(DataSetConfiguration.setter(Builder::columnGroupSchemaList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroupSchemaList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnGroupSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEHOLDER_FIELD, DATA_SET_SCHEMA_FIELD, COLUMN_GROUP_SCHEMA_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String placeholder;
    private final DataSetSchema dataSetSchema;
    private final List<ColumnGroupSchema> columnGroupSchemaList;

    private DataSetConfiguration(BuilderImpl builder) {
        this.placeholder = builder.placeholder;
        this.dataSetSchema = builder.dataSetSchema;
        this.columnGroupSchemaList = builder.columnGroupSchemaList;
    }

    public final String placeholder() {
        return this.placeholder;
    }

    public final DataSetSchema dataSetSchema() {
        return this.dataSetSchema;
    }

    public final boolean hasColumnGroupSchemaList() {
        return this.columnGroupSchemaList != null && !(this.columnGroupSchemaList instanceof SdkAutoConstructList);
    }

    public final List<ColumnGroupSchema> columnGroupSchemaList() {
        return this.columnGroupSchemaList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placeholder());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnGroupSchemaList() ? this.columnGroupSchemaList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetConfiguration)) {
            return false;
        }
        DataSetConfiguration other = (DataSetConfiguration)obj;
        return Objects.equals(this.placeholder(), other.placeholder()) && Objects.equals(this.dataSetSchema(), other.dataSetSchema()) && this.hasColumnGroupSchemaList() == other.hasColumnGroupSchemaList() && Objects.equals(this.columnGroupSchemaList(), other.columnGroupSchemaList());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetConfiguration").add("Placeholder", (Object)this.placeholder()).add("DataSetSchema", (Object)this.dataSetSchema()).add("ColumnGroupSchemaList", this.hasColumnGroupSchemaList() ? this.columnGroupSchemaList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Placeholder": {
                return Optional.ofNullable(clazz.cast(this.placeholder()));
            }
            case "DataSetSchema": {
                return Optional.ofNullable(clazz.cast(this.dataSetSchema()));
            }
            case "ColumnGroupSchemaList": {
                return Optional.ofNullable(clazz.cast(this.columnGroupSchemaList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetConfiguration, T> g) {
        return obj -> g.apply((DataSetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placeholder;
        private DataSetSchema dataSetSchema;
        private List<ColumnGroupSchema> columnGroupSchemaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetConfiguration model) {
            this.placeholder(model.placeholder);
            this.dataSetSchema(model.dataSetSchema);
            this.columnGroupSchemaList(model.columnGroupSchemaList);
        }

        public final String getPlaceholder() {
            return this.placeholder;
        }

        public final void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public final Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final DataSetSchema.Builder getDataSetSchema() {
            return this.dataSetSchema != null ? this.dataSetSchema.toBuilder() : null;
        }

        public final void setDataSetSchema(DataSetSchema.BuilderImpl dataSetSchema) {
            this.dataSetSchema = dataSetSchema != null ? dataSetSchema.build() : null;
        }

        @Override
        public final Builder dataSetSchema(DataSetSchema dataSetSchema) {
            this.dataSetSchema = dataSetSchema;
            return this;
        }

        public final List<ColumnGroupSchema.Builder> getColumnGroupSchemaList() {
            List<ColumnGroupSchema.Builder> result = ColumnGroupSchemaListCopier.copyToBuilder(this.columnGroupSchemaList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnGroupSchemaList(Collection<ColumnGroupSchema.BuilderImpl> columnGroupSchemaList) {
            this.columnGroupSchemaList = ColumnGroupSchemaListCopier.copyFromBuilder(columnGroupSchemaList);
        }

        @Override
        public final Builder columnGroupSchemaList(Collection<ColumnGroupSchema> columnGroupSchemaList) {
            this.columnGroupSchemaList = ColumnGroupSchemaListCopier.copy(columnGroupSchemaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupSchemaList(ColumnGroupSchema ... columnGroupSchemaList) {
            this.columnGroupSchemaList(Arrays.asList(columnGroupSchemaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupSchemaList(Consumer<ColumnGroupSchema.Builder> ... columnGroupSchemaList) {
            this.columnGroupSchemaList(Stream.of(columnGroupSchemaList).map(c -> (ColumnGroupSchema)((ColumnGroupSchema.Builder)ColumnGroupSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataSetConfiguration build() {
            return new DataSetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetConfiguration> {
        public Builder placeholder(String var1);

        public Builder dataSetSchema(DataSetSchema var1);

        default public Builder dataSetSchema(Consumer<DataSetSchema.Builder> dataSetSchema) {
            return this.dataSetSchema((DataSetSchema)((DataSetSchema.Builder)DataSetSchema.builder().applyMutation(dataSetSchema)).build());
        }

        public Builder columnGroupSchemaList(Collection<ColumnGroupSchema> var1);

        public Builder columnGroupSchemaList(ColumnGroupSchema ... var1);

        public Builder columnGroupSchemaList(Consumer<ColumnGroupSchema.Builder> ... var1);
    }
}

