/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUser;
import software.amazon.awssdk.services.quicksight.model.SnapshotAnonymousUserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotUserConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotUserConfiguration> {
    private static final SdkField<List<SnapshotAnonymousUser>> ANONYMOUS_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnonymousUsers").getter(SnapshotUserConfiguration.getter(SnapshotUserConfiguration::anonymousUsers)).setter(SnapshotUserConfiguration.setter(Builder::anonymousUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnonymousUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotAnonymousUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMOUS_USERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SnapshotAnonymousUser> anonymousUsers;

    private SnapshotUserConfiguration(BuilderImpl builder) {
        this.anonymousUsers = builder.anonymousUsers;
    }

    public final boolean hasAnonymousUsers() {
        return this.anonymousUsers != null && !(this.anonymousUsers instanceof SdkAutoConstructList);
    }

    public final List<SnapshotAnonymousUser> anonymousUsers() {
        return this.anonymousUsers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnonymousUsers() ? this.anonymousUsers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotUserConfiguration)) {
            return false;
        }
        SnapshotUserConfiguration other = (SnapshotUserConfiguration)obj;
        return this.hasAnonymousUsers() == other.hasAnonymousUsers() && Objects.equals(this.anonymousUsers(), other.anonymousUsers());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotUserConfiguration").add("AnonymousUsers", this.hasAnonymousUsers() ? this.anonymousUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnonymousUsers": {
                return Optional.ofNullable(clazz.cast(this.anonymousUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotUserConfiguration, T> g) {
        return obj -> g.apply((SnapshotUserConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SnapshotAnonymousUser> anonymousUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotUserConfiguration model) {
            this.anonymousUsers(model.anonymousUsers);
        }

        public final List<SnapshotAnonymousUser.Builder> getAnonymousUsers() {
            List<SnapshotAnonymousUser.Builder> result = SnapshotAnonymousUserListCopier.copyToBuilder(this.anonymousUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnonymousUsers(Collection<SnapshotAnonymousUser.BuilderImpl> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserListCopier.copyFromBuilder(anonymousUsers);
        }

        @Override
        public final Builder anonymousUsers(Collection<SnapshotAnonymousUser> anonymousUsers) {
            this.anonymousUsers = SnapshotAnonymousUserListCopier.copy(anonymousUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(SnapshotAnonymousUser ... anonymousUsers) {
            this.anonymousUsers(Arrays.asList(anonymousUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anonymousUsers(Consumer<SnapshotAnonymousUser.Builder> ... anonymousUsers) {
            this.anonymousUsers(Stream.of(anonymousUsers).map(c -> (SnapshotAnonymousUser)((SnapshotAnonymousUser.Builder)SnapshotAnonymousUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SnapshotUserConfiguration build() {
            return new SnapshotUserConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotUserConfiguration> {
        public Builder anonymousUsers(Collection<SnapshotAnonymousUser> var1);

        public Builder anonymousUsers(SnapshotAnonymousUser ... var1);

        public Builder anonymousUsers(Consumer<SnapshotAnonymousUser.Builder> ... var1);
    }
}

