/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The top ranked and bottom ranked computation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopBottomRankedComputation implements SdkPojo, Serializable,
        ToCopyableBuilder<TopBottomRankedComputation.Builder, TopBottomRankedComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputationId").getter(getter(TopBottomRankedComputation::computationId))
            .setter(setter(Builder::computationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TopBottomRankedComputation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DimensionField> CATEGORY_FIELD = SdkField.<DimensionField> builder(MarshallingType.SDK_POJO)
            .memberName("Category").getter(getter(TopBottomRankedComputation::category)).setter(setter(Builder::category))
            .constructor(DimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.<MeasureField> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(TopBottomRankedComputation::value)).setter(setter(Builder::value))
            .constructor(MeasureField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Integer> RESULT_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResultSize").getter(getter(TopBottomRankedComputation::resultSize)).setter(setter(Builder::resultSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TopBottomRankedComputation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD,
            NAME_FIELD, CATEGORY_FIELD, VALUE_FIELD, RESULT_SIZE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computationId;

    private final String name;

    private final DimensionField category;

    private final MeasureField value;

    private final Integer resultSize;

    private final String type;

    private TopBottomRankedComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.category = builder.category;
        this.value = builder.value;
        this.resultSize = builder.resultSize;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID for a computation.
     * </p>
     * 
     * @return The ID for a computation.
     */
    public final String computationId() {
        return computationId;
    }

    /**
     * <p>
     * The name of a computation.
     * </p>
     * 
     * @return The name of a computation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The category field that is used in a computation.
     * </p>
     * 
     * @return The category field that is used in a computation.
     */
    public final DimensionField category() {
        return category;
    }

    /**
     * <p>
     * The value field that is used in a computation.
     * </p>
     * 
     * @return The value field that is used in a computation.
     */
    public final MeasureField value() {
        return value;
    }

    /**
     * <p>
     * The result size of a top and bottom ranked computation.
     * </p>
     * 
     * @return The result size of a top and bottom ranked computation.
     */
    public final Integer resultSize() {
        return resultSize;
    }

    /**
     * <p>
     * The computation type. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TOP: A top ranked computation.
     * </p>
     * </li>
     * <li>
     * <p>
     * BOTTOM: A bottom ranked computation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TopBottomComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The computation type. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TOP: A top ranked computation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BOTTOM: A bottom ranked computation.
     *         </p>
     *         </li>
     * @see TopBottomComputationType
     */
    public final TopBottomComputationType type() {
        return TopBottomComputationType.fromValue(type);
    }

    /**
     * <p>
     * The computation type. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TOP: A top ranked computation.
     * </p>
     * </li>
     * <li>
     * <p>
     * BOTTOM: A bottom ranked computation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TopBottomComputationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The computation type. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         TOP: A top ranked computation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BOTTOM: A bottom ranked computation.
     *         </p>
     *         </li>
     * @see TopBottomComputationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomRankedComputation)) {
            return false;
        }
        TopBottomRankedComputation other = (TopBottomRankedComputation) obj;
        return Objects.equals(computationId(), other.computationId()) && Objects.equals(name(), other.name())
                && Objects.equals(category(), other.category()) && Objects.equals(value(), other.value())
                && Objects.equals(resultSize(), other.resultSize()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopBottomRankedComputation").add("ComputationId", computationId()).add("Name", name())
                .add("Category", category()).add("Value", value()).add("ResultSize", resultSize()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputationId":
            return Optional.ofNullable(clazz.cast(computationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ResultSize":
            return Optional.ofNullable(clazz.cast(resultSize()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopBottomRankedComputation, T> g) {
        return obj -> g.apply((TopBottomRankedComputation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopBottomRankedComputation> {
        /**
         * <p>
         * The ID for a computation.
         * </p>
         * 
         * @param computationId
         *        The ID for a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationId(String computationId);

        /**
         * <p>
         * The name of a computation.
         * </p>
         * 
         * @param name
         *        The name of a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * 
         * @param category
         *        The category field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(DimensionField category);

        /**
         * <p>
         * The category field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionField.Builder} avoiding the need
         * to create one manually via {@link DimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #category(DimensionField)}.
         * 
         * @param category
         *        a consumer that will call methods on {@link DimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #category(DimensionField)
         */
        default Builder category(Consumer<DimensionField.Builder> category) {
            return category(DimensionField.builder().applyMutation(category).build());
        }

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * 
         * @param value
         *        The value field that is used in a computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MeasureField value);

        /**
         * <p>
         * The value field that is used in a computation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeasureField.Builder} avoiding the need
         * to create one manually via {@link MeasureField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeasureField.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MeasureField)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MeasureField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MeasureField)
         */
        default Builder value(Consumer<MeasureField.Builder> value) {
            return value(MeasureField.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The result size of a top and bottom ranked computation.
         * </p>
         * 
         * @param resultSize
         *        The result size of a top and bottom ranked computation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSize(Integer resultSize);

        /**
         * <p>
         * The computation type. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TOP: A top ranked computation.
         * </p>
         * </li>
         * <li>
         * <p>
         * BOTTOM: A bottom ranked computation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The computation type. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TOP: A top ranked computation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BOTTOM: A bottom ranked computation.
         *        </p>
         *        </li>
         * @see TopBottomComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomComputationType
         */
        Builder type(String type);

        /**
         * <p>
         * The computation type. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TOP: A top ranked computation.
         * </p>
         * </li>
         * <li>
         * <p>
         * BOTTOM: A bottom ranked computation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The computation type. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        TOP: A top ranked computation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BOTTOM: A bottom ranked computation.
         *        </p>
         *        </li>
         * @see TopBottomComputationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopBottomComputationType
         */
        Builder type(TopBottomComputationType type);
    }

    static final class BuilderImpl implements Builder {
        private String computationId;

        private String name;

        private DimensionField category;

        private MeasureField value;

        private Integer resultSize;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TopBottomRankedComputation model) {
            computationId(model.computationId);
            name(model.name);
            category(model.category);
            value(model.value);
            resultSize(model.resultSize);
            type(model.type);
        }

        public final String getComputationId() {
            return computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getCategory() {
            return category != null ? category.toBuilder() : null;
        }

        public final void setCategory(DimensionField.BuilderImpl category) {
            this.category = category != null ? category.build() : null;
        }

        @Override
        public final Builder category(DimensionField category) {
            this.category = category;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        public final Integer getResultSize() {
            return resultSize;
        }

        public final void setResultSize(Integer resultSize) {
            this.resultSize = resultSize;
        }

        @Override
        public final Builder resultSize(Integer resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TopBottomComputationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TopBottomRankedComputation build() {
            return new TopBottomRankedComputation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
