/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NamespaceErrorType {
    PERMISSION_DENIED("PERMISSION_DENIED"),
    INTERNAL_SERVICE_ERROR("INTERNAL_SERVICE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NamespaceErrorType> VALUE_MAP;
    private final String value;

    private NamespaceErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NamespaceErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NamespaceErrorType> knownValues() {
        EnumSet<NamespaceErrorType> knownValues = EnumSet.allOf(NamespaceErrorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NamespaceErrorType.class, NamespaceErrorType::toString);
    }
}

