/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataLabelContent {
    VALUE("VALUE"),
    PERCENT("PERCENT"),
    VALUE_AND_PERCENT("VALUE_AND_PERCENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataLabelContent> VALUE_MAP;
    private final String value;

    private DataLabelContent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataLabelContent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataLabelContent> knownValues() {
        EnumSet<DataLabelContent> knownValues = EnumSet.allOf(DataLabelContent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataLabelContent.class, DataLabelContent::toString);
    }
}

