/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowLevelPermissionDataSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowLevelPermissionDataSet> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(RowLevelPermissionDataSet.getter(RowLevelPermissionDataSet::namespace)).setter(RowLevelPermissionDataSet.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RowLevelPermissionDataSet.getter(RowLevelPermissionDataSet::arn)).setter(RowLevelPermissionDataSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PERMISSION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionPolicy").getter(RowLevelPermissionDataSet.getter(RowLevelPermissionDataSet::permissionPolicyAsString)).setter(RowLevelPermissionDataSet.setter(Builder::permissionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, ARN_FIELD, PERMISSION_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String arn;
    private final String permissionPolicy;

    private RowLevelPermissionDataSet(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.arn = builder.arn;
        this.permissionPolicy = builder.permissionPolicy;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String arn() {
        return this.arn;
    }

    public final RowLevelPermissionPolicy permissionPolicy() {
        return RowLevelPermissionPolicy.fromValue(this.permissionPolicy);
    }

    public final String permissionPolicyAsString() {
        return this.permissionPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionPolicyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionDataSet)) {
            return false;
        }
        RowLevelPermissionDataSet other = (RowLevelPermissionDataSet)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.permissionPolicyAsString(), other.permissionPolicyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RowLevelPermissionDataSet").add("Namespace", (Object)this.namespace()).add("Arn", (Object)this.arn()).add("PermissionPolicy", (Object)this.permissionPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PermissionPolicy": {
                return Optional.ofNullable(clazz.cast(this.permissionPolicyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionDataSet, T> g) {
        return obj -> g.apply((RowLevelPermissionDataSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String arn;
        private String permissionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionDataSet model) {
            this.namespace(model.namespace);
            this.arn(model.arn);
            this.permissionPolicy(model.permissionPolicy);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPermissionPolicy() {
            return this.permissionPolicy;
        }

        @Override
        public final Builder permissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
            return this;
        }

        @Override
        public final Builder permissionPolicy(RowLevelPermissionPolicy permissionPolicy) {
            this.permissionPolicy(permissionPolicy == null ? null : permissionPolicy.toString());
            return this;
        }

        public final void setPermissionPolicy(String permissionPolicy) {
            this.permissionPolicy = permissionPolicy;
        }

        public RowLevelPermissionDataSet build() {
            return new RowLevelPermissionDataSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowLevelPermissionDataSet> {
        public Builder namespace(String var1);

        public Builder arn(String var1);

        public Builder permissionPolicy(String var1);

        public Builder permissionPolicy(RowLevelPermissionPolicy var1);
    }
}

