/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSourceErrorInfo;
import software.amazon.awssdk.services.quicksight.model.DataSourceParameters;
import software.amazon.awssdk.services.quicksight.model.DataSourceParametersListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSourceType;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.services.quicksight.model.SslProperties;
import software.amazon.awssdk.services.quicksight.model.VpcConnectionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSource> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DataSource.getter(DataSource::arn)).setter(DataSource.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(DataSource.getter(DataSource::dataSourceId)).setter(DataSource.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataSource.getter(DataSource::name)).setter(DataSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DataSource.getter(DataSource::typeAsString)).setter(DataSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DataSource.getter(DataSource::statusAsString)).setter(DataSource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DataSource.getter(DataSource::createdTime)).setter(DataSource.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DataSource.getter(DataSource::lastUpdatedTime)).setter(DataSource.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceParameters").getter(DataSource.getter(DataSource::dataSourceParameters)).setter(DataSource.setter(Builder::dataSourceParameters)).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build()}).build();
    private static final SdkField<List<DataSourceParameters>> ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlternateDataSourceParameters").getter(DataSource.getter(DataSource::alternateDataSourceParameters)).setter(DataSource.setter(Builder::alternateDataSourceParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateDataSourceParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionProperties").getter(DataSource.getter(DataSource::vpcConnectionProperties)).setter(DataSource.setter(Builder::vpcConnectionProperties)).constructor(VpcConnectionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build()}).build();
    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslProperties").getter(DataSource.getter(DataSource::sslProperties)).setter(DataSource.setter(Builder::sslProperties)).constructor(SslProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()}).build();
    private static final SdkField<DataSourceErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorInfo").getter(DataSource.getter(DataSource::errorInfo)).setter(DataSource.setter(Builder::errorInfo)).constructor(DataSourceErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SOURCE_ID_FIELD, NAME_FIELD, TYPE_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DATA_SOURCE_PARAMETERS_FIELD, ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD, ERROR_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String dataSourceId;
    private final String name;
    private final String type;
    private final String status;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final DataSourceParameters dataSourceParameters;
    private final List<DataSourceParameters> alternateDataSourceParameters;
    private final VpcConnectionProperties vpcConnectionProperties;
    private final SslProperties sslProperties;
    private final DataSourceErrorInfo errorInfo;

    private DataSource(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.alternateDataSourceParameters = builder.alternateDataSourceParameters;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
        this.errorInfo = builder.errorInfo;
    }

    public String arn() {
        return this.arn;
    }

    public String dataSourceId() {
        return this.dataSourceId;
    }

    public String name() {
        return this.name;
    }

    public DataSourceType type() {
        return DataSourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public DataSourceParameters dataSourceParameters() {
        return this.dataSourceParameters;
    }

    public boolean hasAlternateDataSourceParameters() {
        return this.alternateDataSourceParameters != null && !(this.alternateDataSourceParameters instanceof SdkAutoConstructList);
    }

    public List<DataSourceParameters> alternateDataSourceParameters() {
        return this.alternateDataSourceParameters;
    }

    public VpcConnectionProperties vpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public SslProperties sslProperties() {
        return this.sslProperties;
    }

    public DataSourceErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternateDataSourceParameters() ? this.alternateDataSourceParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.dataSourceParameters(), other.dataSourceParameters()) && this.hasAlternateDataSourceParameters() == other.hasAlternateDataSourceParameters() && Objects.equals(this.alternateDataSourceParameters(), other.alternateDataSourceParameters()) && Objects.equals(this.vpcConnectionProperties(), other.vpcConnectionProperties()) && Objects.equals(this.sslProperties(), other.sslProperties()) && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public String toString() {
        return ToString.builder((String)"DataSource").add("Arn", (Object)this.arn()).add("DataSourceId", (Object)this.dataSourceId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("DataSourceParameters", (Object)this.dataSourceParameters()).add("AlternateDataSourceParameters", this.hasAlternateDataSourceParameters() ? this.alternateDataSourceParameters() : null).add("VpcConnectionProperties", (Object)this.vpcConnectionProperties()).add("SslProperties", (Object)this.sslProperties()).add("ErrorInfo", (Object)this.errorInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "DataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.dataSourceParameters()));
            }
            case "AlternateDataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.alternateDataSourceParameters()));
            }
            case "VpcConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionProperties()));
            }
            case "SslProperties": {
                return Optional.ofNullable(clazz.cast(this.sslProperties()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String dataSourceId;
        private String name;
        private String type;
        private String status;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private DataSourceParameters dataSourceParameters;
        private List<DataSourceParameters> alternateDataSourceParameters = DefaultSdkAutoConstructList.getInstance();
        private VpcConnectionProperties vpcConnectionProperties;
        private SslProperties sslProperties;
        private DataSourceErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            this.arn(model.arn);
            this.dataSourceId(model.dataSourceId);
            this.name(model.name);
            this.type(model.type);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.dataSourceParameters(model.dataSourceParameters);
            this.alternateDataSourceParameters(model.alternateDataSourceParameters);
            this.vpcConnectionProperties(model.vpcConnectionProperties);
            this.sslProperties(model.sslProperties);
            this.errorInfo(model.errorInfo);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return this.dataSourceParameters != null ? this.dataSourceParameters.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        public final Collection<DataSourceParameters.Builder> getAlternateDataSourceParameters() {
            if (this.alternateDataSourceParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.alternateDataSourceParameters != null ? (Collection)this.alternateDataSourceParameters.stream().map(DataSourceParameters::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copy(alternateDataSourceParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(DataSourceParameters ... alternateDataSourceParameters) {
            this.alternateDataSourceParameters(Arrays.asList(alternateDataSourceParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(Consumer<DataSourceParameters.Builder> ... alternateDataSourceParameters) {
            this.alternateDataSourceParameters(Stream.of(alternateDataSourceParameters).map(c -> (DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlternateDataSourceParameters(Collection<DataSourceParameters.BuilderImpl> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copyFromBuilder(alternateDataSourceParameters);
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return this.vpcConnectionProperties != null ? this.vpcConnectionProperties.toBuilder() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        public final SslProperties.Builder getSslProperties() {
            return this.sslProperties != null ? this.sslProperties.toBuilder() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        public final DataSourceErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(DataSourceErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(DataSourceErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public DataSource build() {
            return new DataSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSource> {
        public Builder arn(String var1);

        public Builder dataSourceId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(DataSourceType var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder dataSourceParameters(DataSourceParameters var1);

        default public Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return this.dataSourceParameters((DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation(dataSourceParameters)).build());
        }

        public Builder alternateDataSourceParameters(Collection<DataSourceParameters> var1);

        public Builder alternateDataSourceParameters(DataSourceParameters ... var1);

        public Builder alternateDataSourceParameters(Consumer<DataSourceParameters.Builder> ... var1);

        public Builder vpcConnectionProperties(VpcConnectionProperties var1);

        default public Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return this.vpcConnectionProperties((VpcConnectionProperties)((VpcConnectionProperties.Builder)VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties)).build());
        }

        public Builder sslProperties(SslProperties var1);

        default public Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return this.sslProperties((SslProperties)((SslProperties.Builder)SslProperties.builder().applyMutation(sslProperties)).build());
        }

        public Builder errorInfo(DataSourceErrorInfo var1);

        default public Builder errorInfo(Consumer<DataSourceErrorInfo.Builder> errorInfo) {
            return this.errorInfo((DataSourceErrorInfo)((DataSourceErrorInfo.Builder)DataSourceErrorInfo.builder().applyMutation(errorInfo)).build());
        }
    }
}

