/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsParameters> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(RdsParameters.getter(RdsParameters::instanceId)).setter(RdsParameters.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RdsParameters.getter(RdsParameters::database)).setter(RdsParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATABASE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String database;

    private RdsParameters(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.database = builder.database;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String database() {
        return this.database;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsParameters)) {
            return false;
        }
        RdsParameters other = (RdsParameters)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.database(), other.database());
    }

    public String toString() {
        return ToString.builder((String)"RdsParameters").add("InstanceId", (Object)this.instanceId()).add("Database", (Object)this.database()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsParameters, T> g) {
        return obj -> g.apply((RdsParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsParameters model) {
            this.instanceId(model.instanceId);
            this.database(model.database);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public RdsParameters build() {
            return new RdsParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsParameters> {
        public Builder instanceId(String var1);

        public Builder database(String var1);
    }
}

