/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that filters rows based on a condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterOperation implements SdkPojo, Serializable, ToCopyableBuilder<FilterOperation.Builder, FilterOperation> {
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FilterOperation::conditionExpression)).setter(setter(Builder::conditionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conditionExpression;

    private FilterOperation(BuilderImpl builder) {
        this.conditionExpression = builder.conditionExpression;
    }

    /**
     * <p>
     * An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in
     * the dataset.
     * </p>
     * 
     * @return An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are
     *         kept in the dataset.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperation)) {
            return false;
        }
        FilterOperation other = (FilterOperation) obj;
        return Objects.equals(conditionExpression(), other.conditionExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FilterOperation").add("ConditionExpression", conditionExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionExpression":
            return Optional.ofNullable(clazz.cast(conditionExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterOperation, T> g) {
        return obj -> g.apply((FilterOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterOperation> {
        /**
         * <p>
         * An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept
         * in the dataset.
         * </p>
         * 
         * @param conditionExpression
         *        An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true
         *        are kept in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);
    }

    static final class BuilderImpl implements Builder {
        private String conditionExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperation model) {
            conditionExpression(model.conditionExpression);
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public FilterOperation build() {
            return new FilterOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
