/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSetResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDataSetResponse.Builder, DescribeDataSetResponse> {
    private static final SdkField<DataSet> DATA_SET_FIELD = SdkField.<DataSet> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDataSetResponse::dataSet)).setter(setter(Builder::dataSet)).constructor(DataSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSet").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDataSetResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeDataSetResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private final DataSet dataSet;

    private final String requestId;

    private final Integer status;

    private DescribeDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.dataSet = builder.dataSet;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Information on the dataset.
     * </p>
     * 
     * @return Information on the dataset.
     */
    public DataSet dataSet() {
        return dataSet;
    }

    /**
     * <p>
     * The AWS request ID for this operation.
     * </p>
     * 
     * @return The AWS request ID for this operation.
     */
    public String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSet());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSetResponse)) {
            return false;
        }
        DescribeDataSetResponse other = (DescribeDataSetResponse) obj;
        return Objects.equals(dataSet(), other.dataSet()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDataSetResponse").add("DataSet", dataSet()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSet":
            return Optional.ofNullable(clazz.cast(dataSet()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSetResponse, T> g) {
        return obj -> g.apply((DescribeDataSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataSetResponse> {
        /**
         * <p>
         * Information on the dataset.
         * </p>
         * 
         * @param dataSet
         *        Information on the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSet(DataSet dataSet);

        /**
         * <p>
         * Information on the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSet.Builder} avoiding the need to create one
         * manually via {@link DataSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSet.Builder#build()} is called immediately and its result is
         * passed to {@link #dataSet(DataSet)}.
         * 
         * @param dataSet
         *        a consumer that will call methods on {@link DataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSet(DataSet)
         */
        default Builder dataSet(Consumer<DataSet.Builder> dataSet) {
            return dataSet(DataSet.builder().applyMutation(dataSet).build());
        }

        /**
         * <p>
         * The AWS request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The AWS request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private DataSet dataSet;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSetResponse model) {
            super(model);
            dataSet(model.dataSet);
            requestId(model.requestId);
            status(model.status);
        }

        public final DataSet.Builder getDataSet() {
            return dataSet != null ? dataSet.toBuilder() : null;
        }

        @Override
        public final Builder dataSet(DataSet dataSet) {
            this.dataSet = dataSet;
            return this;
        }

        public final void setDataSet(DataSet.BuilderImpl dataSet) {
            this.dataSet = dataSet != null ? dataSet.build() : null;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeDataSetResponse build() {
            return new DescribeDataSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
