/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source entity of the template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateSourceEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateSourceEntity.Builder, TemplateSourceEntity> {
    private static final SdkField<TemplateSourceAnalysis> SOURCE_ANALYSIS_FIELD = SdkField
            .<TemplateSourceAnalysis> builder(MarshallingType.SDK_POJO).getter(getter(TemplateSourceEntity::sourceAnalysis))
            .setter(setter(Builder::sourceAnalysis)).constructor(TemplateSourceAnalysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAnalysis").build()).build();

    private static final SdkField<TemplateSourceTemplate> SOURCE_TEMPLATE_FIELD = SdkField
            .<TemplateSourceTemplate> builder(MarshallingType.SDK_POJO).getter(getter(TemplateSourceEntity::sourceTemplate))
            .setter(setter(Builder::sourceTemplate)).constructor(TemplateSourceTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ANALYSIS_FIELD,
            SOURCE_TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final TemplateSourceAnalysis sourceAnalysis;

    private final TemplateSourceTemplate sourceTemplate;

    private TemplateSourceEntity(BuilderImpl builder) {
        this.sourceAnalysis = builder.sourceAnalysis;
        this.sourceTemplate = builder.sourceTemplate;
    }

    /**
     * <p>
     * The source analysis, if it is based on an analysis.
     * </p>
     * 
     * @return The source analysis, if it is based on an analysis.
     */
    public TemplateSourceAnalysis sourceAnalysis() {
        return sourceAnalysis;
    }

    /**
     * <p>
     * The source template, if it is based on an template.
     * </p>
     * 
     * @return The source template, if it is based on an template.
     */
    public TemplateSourceTemplate sourceTemplate() {
        return sourceTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSourceEntity)) {
            return false;
        }
        TemplateSourceEntity other = (TemplateSourceEntity) obj;
        return Objects.equals(sourceAnalysis(), other.sourceAnalysis())
                && Objects.equals(sourceTemplate(), other.sourceTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TemplateSourceEntity").add("SourceAnalysis", sourceAnalysis())
                .add("SourceTemplate", sourceTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceAnalysis":
            return Optional.ofNullable(clazz.cast(sourceAnalysis()));
        case "SourceTemplate":
            return Optional.ofNullable(clazz.cast(sourceTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateSourceEntity, T> g) {
        return obj -> g.apply((TemplateSourceEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateSourceEntity> {
        /**
         * <p>
         * The source analysis, if it is based on an analysis.
         * </p>
         * 
         * @param sourceAnalysis
         *        The source analysis, if it is based on an analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAnalysis(TemplateSourceAnalysis sourceAnalysis);

        /**
         * <p>
         * The source analysis, if it is based on an analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateSourceAnalysis.Builder} avoiding the
         * need to create one manually via {@link TemplateSourceAnalysis#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateSourceAnalysis.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceAnalysis(TemplateSourceAnalysis)}.
         * 
         * @param sourceAnalysis
         *        a consumer that will call methods on {@link TemplateSourceAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAnalysis(TemplateSourceAnalysis)
         */
        default Builder sourceAnalysis(Consumer<TemplateSourceAnalysis.Builder> sourceAnalysis) {
            return sourceAnalysis(TemplateSourceAnalysis.builder().applyMutation(sourceAnalysis).build());
        }

        /**
         * <p>
         * The source template, if it is based on an template.
         * </p>
         * 
         * @param sourceTemplate
         *        The source template, if it is based on an template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTemplate(TemplateSourceTemplate sourceTemplate);

        /**
         * <p>
         * The source template, if it is based on an template.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateSourceTemplate.Builder} avoiding the
         * need to create one manually via {@link TemplateSourceTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateSourceTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceTemplate(TemplateSourceTemplate)}.
         * 
         * @param sourceTemplate
         *        a consumer that will call methods on {@link TemplateSourceTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTemplate(TemplateSourceTemplate)
         */
        default Builder sourceTemplate(Consumer<TemplateSourceTemplate.Builder> sourceTemplate) {
            return sourceTemplate(TemplateSourceTemplate.builder().applyMutation(sourceTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TemplateSourceAnalysis sourceAnalysis;

        private TemplateSourceTemplate sourceTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSourceEntity model) {
            sourceAnalysis(model.sourceAnalysis);
            sourceTemplate(model.sourceTemplate);
        }

        public final TemplateSourceAnalysis.Builder getSourceAnalysis() {
            return sourceAnalysis != null ? sourceAnalysis.toBuilder() : null;
        }

        @Override
        public final Builder sourceAnalysis(TemplateSourceAnalysis sourceAnalysis) {
            this.sourceAnalysis = sourceAnalysis;
            return this;
        }

        public final void setSourceAnalysis(TemplateSourceAnalysis.BuilderImpl sourceAnalysis) {
            this.sourceAnalysis = sourceAnalysis != null ? sourceAnalysis.build() : null;
        }

        public final TemplateSourceTemplate.Builder getSourceTemplate() {
            return sourceTemplate != null ? sourceTemplate.toBuilder() : null;
        }

        @Override
        public final Builder sourceTemplate(TemplateSourceTemplate sourceTemplate) {
            this.sourceTemplate = sourceTemplate;
            return this;
        }

        public final void setSourceTemplate(TemplateSourceTemplate.BuilderImpl sourceTemplate) {
            this.sourceTemplate = sourceTemplate != null ? sourceTemplate.build() : null;
        }

        @Override
        public TemplateSourceEntity build() {
            return new TemplateSourceEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
