/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that tags a column with additional information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagColumnOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<TagColumnOperation.Builder, TagColumnOperation> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TagColumnOperation::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<List<ColumnTag>> TAGS_FIELD = SdkField
            .<List<ColumnTag>> builder(MarshallingType.LIST)
            .getter(getter(TagColumnOperation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final List<ColumnTag> tags;

    private TagColumnOperation(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The column that this operation acts on.
     * </p>
     * 
     * @return The column that this operation acts on.
     */
    public String columnName() {
        return columnName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dataset column tag, currently only used for geospatial type tagging. .
     * </p>
     * <note>
     * <p>
     * This is not tags for the AWS tagging feature. .
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The dataset column tag, currently only used for geospatial type tagging. .</p> <note>
     *         <p>
     *         This is not tags for the AWS tagging feature. .
     *         </p>
     */
    public List<ColumnTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagColumnOperation)) {
            return false;
        }
        TagColumnOperation other = (TagColumnOperation) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TagColumnOperation").add("ColumnName", columnName()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagColumnOperation, T> g) {
        return obj -> g.apply((TagColumnOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagColumnOperation> {
        /**
         * <p>
         * The column that this operation acts on.
         * </p>
         * 
         * @param columnName
         *        The column that this operation acts on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging. .
         * </p>
         * <note>
         * <p>
         * This is not tags for the AWS tagging feature. .
         * </p>
         * </note>
         * 
         * @param tags
         *        The dataset column tag, currently only used for geospatial type tagging. .</p> <note>
         *        <p>
         *        This is not tags for the AWS tagging feature. .
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<ColumnTag> tags);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging. .
         * </p>
         * <note>
         * <p>
         * This is not tags for the AWS tagging feature. .
         * </p>
         * </note>
         * 
         * @param tags
         *        The dataset column tag, currently only used for geospatial type tagging. .</p> <note>
         *        <p>
         *        This is not tags for the AWS tagging feature. .
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(ColumnTag... tags);

        /**
         * <p>
         * The dataset column tag, currently only used for geospatial type tagging. .
         * </p>
         * <note>
         * <p>
         * This is not tags for the AWS tagging feature. .
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<ColumnTag>.Builder} avoiding the
         * need to create one manually via {@link List<ColumnTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<ColumnTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<ColumnTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<ColumnTag>)
         */
        Builder tags(Consumer<ColumnTag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private List<ColumnTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagColumnOperation model) {
            columnName(model.columnName);
            tags(model.tags);
        }

        public final String getColumnName() {
            return columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final Collection<ColumnTag.Builder> getTags() {
            return tags != null ? tags.stream().map(ColumnTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<ColumnTag> tags) {
            this.tags = ColumnTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(ColumnTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<ColumnTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> ColumnTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<ColumnTag.BuilderImpl> tags) {
            this.tags = ColumnTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TagColumnOperation build() {
            return new TagColumnOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
