/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a queued dataset SPICE ingestion.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueInfo implements SdkPojo, Serializable, ToCopyableBuilder<QueueInfo.Builder, QueueInfo> {
    private static final SdkField<String> WAITING_ON_INGESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueueInfo::waitingOnIngestion)).setter(setter(Builder::waitingOnIngestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitingOnIngestion").build())
            .build();

    private static final SdkField<String> QUEUED_INGESTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueueInfo::queuedIngestion)).setter(setter(Builder::queuedIngestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuedIngestion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAITING_ON_INGESTION_FIELD,
            QUEUED_INGESTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String waitingOnIngestion;

    private final String queuedIngestion;

    private QueueInfo(BuilderImpl builder) {
        this.waitingOnIngestion = builder.waitingOnIngestion;
        this.queuedIngestion = builder.queuedIngestion;
    }

    /**
     * <p>
     * The ID of the queued ingestion.
     * </p>
     * 
     * @return The ID of the queued ingestion.
     */
    public String waitingOnIngestion() {
        return waitingOnIngestion;
    }

    /**
     * <p>
     * The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.
     * </p>
     * 
     * @return The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.
     */
    public String queuedIngestion() {
        return queuedIngestion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(waitingOnIngestion());
        hashCode = 31 * hashCode + Objects.hashCode(queuedIngestion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueInfo)) {
            return false;
        }
        QueueInfo other = (QueueInfo) obj;
        return Objects.equals(waitingOnIngestion(), other.waitingOnIngestion())
                && Objects.equals(queuedIngestion(), other.queuedIngestion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueueInfo").add("WaitingOnIngestion", waitingOnIngestion())
                .add("QueuedIngestion", queuedIngestion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WaitingOnIngestion":
            return Optional.ofNullable(clazz.cast(waitingOnIngestion()));
        case "QueuedIngestion":
            return Optional.ofNullable(clazz.cast(queuedIngestion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueInfo, T> g) {
        return obj -> g.apply((QueueInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueInfo> {
        /**
         * <p>
         * The ID of the queued ingestion.
         * </p>
         * 
         * @param waitingOnIngestion
         *        The ID of the queued ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitingOnIngestion(String waitingOnIngestion);

        /**
         * <p>
         * The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to complete.
         * </p>
         * 
         * @param queuedIngestion
         *        The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing ingestion to
         *        complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedIngestion(String queuedIngestion);
    }

    static final class BuilderImpl implements Builder {
        private String waitingOnIngestion;

        private String queuedIngestion;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueInfo model) {
            waitingOnIngestion(model.waitingOnIngestion);
            queuedIngestion(model.queuedIngestion);
        }

        public final String getWaitingOnIngestion() {
            return waitingOnIngestion;
        }

        @Override
        public final Builder waitingOnIngestion(String waitingOnIngestion) {
            this.waitingOnIngestion = waitingOnIngestion;
            return this;
        }

        public final void setWaitingOnIngestion(String waitingOnIngestion) {
            this.waitingOnIngestion = waitingOnIngestion;
        }

        public final String getQueuedIngestion() {
            return queuedIngestion;
        }

        @Override
        public final Builder queuedIngestion(String queuedIngestion) {
            this.queuedIngestion = queuedIngestion;
            return this;
        }

        public final void setQueuedIngestion(String queuedIngestion) {
            this.queuedIngestion = queuedIngestion;
        }

        @Override
        public QueueInfo build() {
            return new QueueInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
