/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the source of a logical table. This is a variant type structure. For this structure to be valid,
 * only one of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogicalTableSource implements SdkPojo, Serializable,
        ToCopyableBuilder<LogicalTableSource.Builder, LogicalTableSource> {
    private static final SdkField<JoinInstruction> JOIN_INSTRUCTION_FIELD = SdkField
            .<JoinInstruction> builder(MarshallingType.SDK_POJO).getter(getter(LogicalTableSource::joinInstruction))
            .setter(setter(Builder::joinInstruction)).constructor(JoinInstruction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinInstruction").build()).build();

    private static final SdkField<String> PHYSICAL_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogicalTableSource::physicalTableId)).setter(setter(Builder::physicalTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_INSTRUCTION_FIELD,
            PHYSICAL_TABLE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final JoinInstruction joinInstruction;

    private final String physicalTableId;

    private LogicalTableSource(BuilderImpl builder) {
        this.joinInstruction = builder.joinInstruction;
        this.physicalTableId = builder.physicalTableId;
    }

    /**
     * <p>
     * Specifies the result of a join of two logical tables.
     * </p>
     * 
     * @return Specifies the result of a join of two logical tables.
     */
    public JoinInstruction joinInstruction() {
        return joinInstruction;
    }

    /**
     * <p>
     * Physical table ID.
     * </p>
     * 
     * @return Physical table ID.
     */
    public String physicalTableId() {
        return physicalTableId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(joinInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(physicalTableId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalTableSource)) {
            return false;
        }
        LogicalTableSource other = (LogicalTableSource) obj;
        return Objects.equals(joinInstruction(), other.joinInstruction())
                && Objects.equals(physicalTableId(), other.physicalTableId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LogicalTableSource").add("JoinInstruction", joinInstruction())
                .add("PhysicalTableId", physicalTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JoinInstruction":
            return Optional.ofNullable(clazz.cast(joinInstruction()));
        case "PhysicalTableId":
            return Optional.ofNullable(clazz.cast(physicalTableId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogicalTableSource, T> g) {
        return obj -> g.apply((LogicalTableSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogicalTableSource> {
        /**
         * <p>
         * Specifies the result of a join of two logical tables.
         * </p>
         * 
         * @param joinInstruction
         *        Specifies the result of a join of two logical tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinInstruction(JoinInstruction joinInstruction);

        /**
         * <p>
         * Specifies the result of a join of two logical tables.
         * </p>
         * This is a convenience that creates an instance of the {@link JoinInstruction.Builder} avoiding the need to
         * create one manually via {@link JoinInstruction#builder()}.
         *
         * When the {@link Consumer} completes, {@link JoinInstruction.Builder#build()} is called immediately and its
         * result is passed to {@link #joinInstruction(JoinInstruction)}.
         * 
         * @param joinInstruction
         *        a consumer that will call methods on {@link JoinInstruction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #joinInstruction(JoinInstruction)
         */
        default Builder joinInstruction(Consumer<JoinInstruction.Builder> joinInstruction) {
            return joinInstruction(JoinInstruction.builder().applyMutation(joinInstruction).build());
        }

        /**
         * <p>
         * Physical table ID.
         * </p>
         * 
         * @param physicalTableId
         *        Physical table ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalTableId(String physicalTableId);
    }

    static final class BuilderImpl implements Builder {
        private JoinInstruction joinInstruction;

        private String physicalTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalTableSource model) {
            joinInstruction(model.joinInstruction);
            physicalTableId(model.physicalTableId);
        }

        public final JoinInstruction.Builder getJoinInstruction() {
            return joinInstruction != null ? joinInstruction.toBuilder() : null;
        }

        @Override
        public final Builder joinInstruction(JoinInstruction joinInstruction) {
            this.joinInstruction = joinInstruction;
            return this;
        }

        public final void setJoinInstruction(JoinInstruction.BuilderImpl joinInstruction) {
            this.joinInstruction = joinInstruction != null ? joinInstruction.build() : null;
        }

        public final String getPhysicalTableId() {
            return physicalTableId;
        }

        @Override
        public final Builder physicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
            return this;
        }

        public final void setPhysicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
        }

        @Override
        public LogicalTableSource build() {
            return new LogicalTableSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
