/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.LedgerEncryptionDescription;
import software.amazon.awssdk.services.qldb.model.LedgerState;
import software.amazon.awssdk.services.qldb.model.PermissionsMode;
import software.amazon.awssdk.services.qldb.model.QldbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLedgerResponse
extends QldbResponse
implements ToCopyableBuilder<Builder, DescribeLedgerResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::name)).setter(DescribeLedgerResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::arn)).setter(DescribeLedgerResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::stateAsString)).setter(DescribeLedgerResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDateTime").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::creationDateTime)).setter(DescribeLedgerResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionsMode").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::permissionsModeAsString)).setter(DescribeLedgerResponse.setter(Builder::permissionsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::deletionProtection)).setter(DescribeLedgerResponse.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<LedgerEncryptionDescription> ENCRYPTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionDescription").getter(DescribeLedgerResponse.getter(DescribeLedgerResponse::encryptionDescription)).setter(DescribeLedgerResponse.setter(Builder::encryptionDescription)).constructor(LedgerEncryptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, STATE_FIELD, CREATION_DATE_TIME_FIELD, PERMISSIONS_MODE_FIELD, DELETION_PROTECTION_FIELD, ENCRYPTION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLedgerResponse.memberNameToFieldInitializer();
    private final String name;
    private final String arn;
    private final String state;
    private final Instant creationDateTime;
    private final String permissionsMode;
    private final Boolean deletionProtection;
    private final LedgerEncryptionDescription encryptionDescription;

    private DescribeLedgerResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
        this.permissionsMode = builder.permissionsMode;
        this.deletionProtection = builder.deletionProtection;
        this.encryptionDescription = builder.encryptionDescription;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final LedgerState state() {
        return LedgerState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(this.permissionsMode);
    }

    public final String permissionsModeAsString() {
        return this.permissionsMode;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final LedgerEncryptionDescription encryptionDescription() {
        return this.encryptionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLedgerResponse)) {
            return false;
        }
        DescribeLedgerResponse other = (DescribeLedgerResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.permissionsModeAsString(), other.permissionsModeAsString()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.encryptionDescription(), other.encryptionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLedgerResponse").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("State", (Object)this.stateAsString()).add("CreationDateTime", (Object)this.creationDateTime()).add("PermissionsMode", (Object)this.permissionsModeAsString()).add("DeletionProtection", (Object)this.deletionProtection()).add("EncryptionDescription", (Object)this.encryptionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "PermissionsMode": {
                return Optional.ofNullable(clazz.cast(this.permissionsModeAsString()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "EncryptionDescription": {
                return Optional.ofNullable(clazz.cast(this.encryptionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("CreationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("PermissionsMode", PERMISSIONS_MODE_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("EncryptionDescription", ENCRYPTION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLedgerResponse, T> g) {
        return obj -> g.apply((DescribeLedgerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QldbResponse.BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String state;
        private Instant creationDateTime;
        private String permissionsMode;
        private Boolean deletionProtection;
        private LedgerEncryptionDescription encryptionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLedgerResponse model) {
            super(model);
            this.name(model.name);
            this.arn(model.arn);
            this.state(model.state);
            this.creationDateTime(model.creationDateTime);
            this.permissionsMode(model.permissionsMode);
            this.deletionProtection(model.deletionProtection);
            this.encryptionDescription(model.encryptionDescription);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LedgerState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getPermissionsMode() {
            return this.permissionsMode;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        @Override
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final LedgerEncryptionDescription.Builder getEncryptionDescription() {
            return this.encryptionDescription != null ? this.encryptionDescription.toBuilder() : null;
        }

        public final void setEncryptionDescription(LedgerEncryptionDescription.BuilderImpl encryptionDescription) {
            this.encryptionDescription = encryptionDescription != null ? encryptionDescription.build() : null;
        }

        @Override
        public final Builder encryptionDescription(LedgerEncryptionDescription encryptionDescription) {
            this.encryptionDescription = encryptionDescription;
            return this;
        }

        @Override
        public DescribeLedgerResponse build() {
            return new DescribeLedgerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QldbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLedgerResponse> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder state(String var1);

        public Builder state(LedgerState var1);

        public Builder creationDateTime(Instant var1);

        public Builder permissionsMode(String var1);

        public Builder permissionsMode(PermissionsMode var1);

        public Builder deletionProtection(Boolean var1);

        public Builder encryptionDescription(LedgerEncryptionDescription var1);

        default public Builder encryptionDescription(Consumer<LedgerEncryptionDescription.Builder> encryptionDescription) {
            return this.encryptionDescription((LedgerEncryptionDescription)((LedgerEncryptionDescription.Builder)LedgerEncryptionDescription.builder().applyMutation(encryptionDescription)).build());
        }
    }
}

