/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCause {
    KINESIS_STREAM_NOT_FOUND("KINESIS_STREAM_NOT_FOUND"),
    IAM_PERMISSION_REVOKED("IAM_PERMISSION_REVOKED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCause(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCause fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCause.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCause> knownValues() {
        return Stream.of(ErrorCause.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

