/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qldb.model.S3EncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ExportConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ExportConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ExportConfiguration.getter(S3ExportConfiguration::bucket)).setter(S3ExportConfiguration.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3ExportConfiguration.getter(S3ExportConfiguration::prefix)).setter(S3ExportConfiguration.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<S3EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3ExportConfiguration.getter(S3ExportConfiguration::encryptionConfiguration)).setter(S3ExportConfiguration.setter(Builder::encryptionConfiguration)).constructor(S3EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PREFIX_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String prefix;
    private final S3EncryptionConfiguration encryptionConfiguration;

    private S3ExportConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public S3EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportConfiguration)) {
            return false;
        }
        S3ExportConfiguration other = (S3ExportConfiguration)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"S3ExportConfiguration").add("Bucket", (Object)this.bucket()).add("Prefix", (Object)this.prefix()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ExportConfiguration, T> g) {
        return obj -> g.apply((S3ExportConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String prefix;
        private S3EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportConfiguration model) {
            this.bucket(model.bucket);
            this.prefix(model.prefix);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final S3EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder encryptionConfiguration(S3EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final void setEncryptionConfiguration(S3EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        public S3ExportConfiguration build() {
            return new S3ExportConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ExportConfiguration> {
        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder encryptionConfiguration(S3EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<S3EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((S3EncryptionConfiguration)((S3EncryptionConfiguration.Builder)S3EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

