/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamJournalToKinesisRequest extends QldbRequest implements
        ToCopyableBuilder<StreamJournalToKinesisRequest.Builder, StreamJournalToKinesisRequest> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamJournalToKinesisRequest::ledgerName)).setter(setter(Builder::ledgerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamJournalToKinesisRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(StreamJournalToKinesisRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StreamJournalToKinesisRequest::inclusiveStartTime)).setter(setter(Builder::inclusiveStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build())
            .build();

    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StreamJournalToKinesisRequest::exclusiveEndTime)).setter(setter(Builder::exclusiveEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()).build();

    private static final SdkField<KinesisConfiguration> KINESIS_CONFIGURATION_FIELD = SdkField
            .<KinesisConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(StreamJournalToKinesisRequest::kinesisConfiguration)).setter(setter(Builder::kinesisConfiguration))
            .constructor(KinesisConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisConfiguration").build())
            .build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StreamJournalToKinesisRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD,
            ROLE_ARN_FIELD, TAGS_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, KINESIS_CONFIGURATION_FIELD,
            STREAM_NAME_FIELD));

    private final String ledgerName;

    private final String roleArn;

    private final Map<String, String> tags;

    private final Instant inclusiveStartTime;

    private final Instant exclusiveEndTime;

    private final KinesisConfiguration kinesisConfiguration;

    private final String streamName;

    private StreamJournalToKinesisRequest(BuilderImpl builder) {
        super(builder);
        this.ledgerName = builder.ledgerName;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.kinesisConfiguration = builder.kinesisConfiguration;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public String ledgerName() {
        return ledgerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data
     * records to a Kinesis Data Streams resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write
     *         data records to a Kinesis Data Streams resource.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values
     * are case sensitive and can be null.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive.
     *         Tag values are case sensitive and can be null.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The inclusive start date and time from which to start streaming journal data. This parameter must be in
     * <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example:
     * <code>2019-06-13T21:36:34Z</code>
     * </p>
     * <p>
     * The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code>.
     * </p>
     * <p>
     * If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>, QLDB
     * effectively defaults it to the ledger's <code>CreationDateTime</code>.
     * </p>
     * 
     * @return The inclusive start date and time from which to start streaming journal data. This parameter must be in
     *         <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example:
     *         <code>2019-06-13T21:36:34Z</code> </p>
     *         <p>
     *         The <code>InclusiveStartTime</code> cannot be in the future and must be before
     *         <code>ExclusiveEndTime</code>.
     *         </p>
     *         <p>
     *         If you provide an <code>InclusiveStartTime</code> that is before the ledger's
     *         <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's <code>CreationDateTime</code>.
     */
    public Instant inclusiveStartTime() {
        return inclusiveStartTime;
    }

    /**
     * <p>
     * The exclusive date and time that specifies when the stream ends. If you keep this parameter blank, the stream
     * runs indefinitely until you cancel it.
     * </p>
     * <p>
     * The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
     * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     * </p>
     * 
     * @return The exclusive date and time that specifies when the stream ends. If you keep this parameter blank, the
     *         stream runs indefinitely until you cancel it.</p>
     *         <p>
     *         The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
     *         Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
     */
    public Instant exclusiveEndTime() {
        return exclusiveEndTime;
    }

    /**
     * <p>
     * The configuration settings of the Kinesis Data Streams destination for your stream request.
     * </p>
     * 
     * @return The configuration settings of the Kinesis Data Streams destination for your stream request.
     */
    public KinesisConfiguration kinesisConfiguration() {
        return kinesisConfiguration;
    }

    /**
     * <p>
     * The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate
     * the purpose of a stream.
     * </p>
     * <p>
     * Your stream name must be unique among other <i>active</i> streams for a given ledger. If you try to create a
     * stream with the same name and configuration of an active, existing stream for the same ledger, QLDB simply
     * returns the existing stream. Stream names have the same naming constraints as ledger names, as defined in <a
     * href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB</a>
     * in the <i>Amazon QLDB Developer Guide</i>.
     * </p>
     * 
     * @return The name that you want to assign to the QLDB journal stream. User-defined names can help identify and
     *         indicate the purpose of a stream.</p>
     *         <p>
     *         Your stream name must be unique among other <i>active</i> streams for a given ledger. If you try to
     *         create a stream with the same name and configuration of an active, existing stream for the same ledger,
     *         QLDB simply returns the existing stream. Stream names have the same naming constraints as ledger names,
     *         as defined in <a
     *         href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon
     *         QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.
     */
    public String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamJournalToKinesisRequest)) {
            return false;
        }
        StreamJournalToKinesisRequest other = (StreamJournalToKinesisRequest) obj;
        return Objects.equals(ledgerName(), other.ledgerName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(tags(), other.tags()) && Objects.equals(inclusiveStartTime(), other.inclusiveStartTime())
                && Objects.equals(exclusiveEndTime(), other.exclusiveEndTime())
                && Objects.equals(kinesisConfiguration(), other.kinesisConfiguration())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamJournalToKinesisRequest").add("LedgerName", ledgerName()).add("RoleArn", roleArn())
                .add("Tags", tags()).add("InclusiveStartTime", inclusiveStartTime()).add("ExclusiveEndTime", exclusiveEndTime())
                .add("KinesisConfiguration", kinesisConfiguration()).add("StreamName", streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LedgerName":
            return Optional.ofNullable(clazz.cast(ledgerName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "InclusiveStartTime":
            return Optional.ofNullable(clazz.cast(inclusiveStartTime()));
        case "ExclusiveEndTime":
            return Optional.ofNullable(clazz.cast(exclusiveEndTime()));
        case "KinesisConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisConfiguration()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamJournalToKinesisRequest, T> g) {
        return obj -> g.apply((StreamJournalToKinesisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, StreamJournalToKinesisRequest> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param ledgerName
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ledgerName(String ledgerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write
         * data records to a Kinesis Data Streams resource.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to
         *        write data records to a Kinesis Data Streams resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag
         * values are case sensitive and can be null.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive.
         *        Tag values are case sensitive and can be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The inclusive start date and time from which to start streaming journal data. This parameter must be in
         * <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example:
         * <code>2019-06-13T21:36:34Z</code>
         * </p>
         * <p>
         * The <code>InclusiveStartTime</code> cannot be in the future and must be before <code>ExclusiveEndTime</code>.
         * </p>
         * <p>
         * If you provide an <code>InclusiveStartTime</code> that is before the ledger's <code>CreationDateTime</code>,
         * QLDB effectively defaults it to the ledger's <code>CreationDateTime</code>.
         * </p>
         * 
         * @param inclusiveStartTime
         *        The inclusive start date and time from which to start streaming journal data. This parameter must be
         *        in <code>ISO 8601</code> date and time format and in Universal Coordinated Time (UTC). For example:
         *        <code>2019-06-13T21:36:34Z</code> </p>
         *        <p>
         *        The <code>InclusiveStartTime</code> cannot be in the future and must be before
         *        <code>ExclusiveEndTime</code>.
         *        </p>
         *        <p>
         *        If you provide an <code>InclusiveStartTime</code> that is before the ledger's
         *        <code>CreationDateTime</code>, QLDB effectively defaults it to the ledger's
         *        <code>CreationDateTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusiveStartTime(Instant inclusiveStartTime);

        /**
         * <p>
         * The exclusive date and time that specifies when the stream ends. If you keep this parameter blank, the stream
         * runs indefinitely until you cancel it.
         * </p>
         * <p>
         * The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in Universal
         * Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         * </p>
         * 
         * @param exclusiveEndTime
         *        The exclusive date and time that specifies when the stream ends. If you keep this parameter blank, the
         *        stream runs indefinitely until you cancel it.</p>
         *        <p>
         *        The <code>ExclusiveEndTime</code> must be in <code>ISO 8601</code> date and time format and in
         *        Universal Coordinated Time (UTC). For example: <code>2019-06-13T21:36:34Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveEndTime(Instant exclusiveEndTime);

        /**
         * <p>
         * The configuration settings of the Kinesis Data Streams destination for your stream request.
         * </p>
         * 
         * @param kinesisConfiguration
         *        The configuration settings of the Kinesis Data Streams destination for your stream request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration);

        /**
         * <p>
         * The configuration settings of the Kinesis Data Streams destination for your stream request.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisConfiguration.Builder} avoiding the need
         * to create one manually via {@link KinesisConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisConfiguration(KinesisConfiguration)}.
         * 
         * @param kinesisConfiguration
         *        a consumer that will call methods on {@link KinesisConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisConfiguration(KinesisConfiguration)
         */
        default Builder kinesisConfiguration(Consumer<KinesisConfiguration.Builder> kinesisConfiguration) {
            return kinesisConfiguration(KinesisConfiguration.builder().applyMutation(kinesisConfiguration).build());
        }

        /**
         * <p>
         * The name that you want to assign to the QLDB journal stream. User-defined names can help identify and
         * indicate the purpose of a stream.
         * </p>
         * <p>
         * Your stream name must be unique among other <i>active</i> streams for a given ledger. If you try to create a
         * stream with the same name and configuration of an active, existing stream for the same ledger, QLDB simply
         * returns the existing stream. Stream names have the same naming constraints as ledger names, as defined in <a
         * href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon
         * QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.
         * </p>
         * 
         * @param streamName
         *        The name that you want to assign to the QLDB journal stream. User-defined names can help identify and
         *        indicate the purpose of a stream.</p>
         *        <p>
         *        Your stream name must be unique among other <i>active</i> streams for a given ledger. If you try to
         *        create a stream with the same name and configuration of an active, existing stream for the same
         *        ledger, QLDB simply returns the existing stream. Stream names have the same naming constraints as
         *        ledger names, as defined in <a
         *        href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in
         *        Amazon QLDB</a> in the <i>Amazon QLDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String ledgerName;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant inclusiveStartTime;

        private Instant exclusiveEndTime;

        private KinesisConfiguration kinesisConfiguration;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamJournalToKinesisRequest model) {
            super(model);
            ledgerName(model.ledgerName);
            roleArn(model.roleArn);
            tags(model.tags);
            inclusiveStartTime(model.inclusiveStartTime);
            exclusiveEndTime(model.exclusiveEndTime);
            kinesisConfiguration(model.kinesisConfiguration);
            streamName(model.streamName);
        }

        public final String getLedgerName() {
            return ledgerName;
        }

        @Override
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Instant getInclusiveStartTime() {
            return inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        public final Instant getExclusiveEndTime() {
            return exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        public final KinesisConfiguration.Builder getKinesisConfiguration() {
            return kinesisConfiguration != null ? kinesisConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        public final void setKinesisConfiguration(KinesisConfiguration.BuilderImpl kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration != null ? kinesisConfiguration.build() : null;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StreamJournalToKinesisRequest build() {
            return new StreamJournalToKinesisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
