/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLedgerRequest extends QldbRequest implements
        ToCopyableBuilder<CreateLedgerRequest.Builder, CreateLedgerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLedgerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateLedgerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PERMISSIONS_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLedgerRequest::permissionsModeAsString)).setter(setter(Builder::permissionsMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsMode").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateLedgerRequest::deletionProtection)).setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TAGS_FIELD,
            PERMISSIONS_MODE_FIELD, DELETION_PROTECTION_FIELD));

    private final String name;

    private final Map<String, String> tags;

    private final String permissionsMode;

    private final Boolean deletionProtection;

    private CreateLedgerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.tags = builder.tags;
        this.permissionsMode = builder.permissionsMode;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The name of the ledger that you want to create. The name must be unique among all of your ledgers in the current
     * AWS Region.
     * </p>
     * 
     * @return The name of the ledger that you want to create. The name must be unique among all of your ledgers in the
     *         current AWS Region.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag values
     * are case sensitive and can be null.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive.
     *         Tag values are case sensitive and can be null.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The permissions mode to assign to the ledger that you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode to assign to the ledger that you want to create.
     * @see PermissionsMode
     */
    public PermissionsMode permissionsMode() {
        return PermissionsMode.fromValue(permissionsMode);
    }

    /**
     * <p>
     * The permissions mode to assign to the ledger that you want to create.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionsMode}
     * will return {@link PermissionsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionsModeAsString}.
     * </p>
     * 
     * @return The permissions mode to assign to the ledger that you want to create.
     * @see PermissionsMode
     */
    public String permissionsModeAsString() {
        return permissionsMode;
    }

    /**
     * <p>
     * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature
     * is enabled (<code>true</code>) by default.
     * </p>
     * <p>
     * If deletion protection is enabled, you must first disable it before you can delete the ledger using the QLDB API
     * or the AWS Command Line Interface (AWS CLI). You can disable it by calling the <code>UpdateLedger</code>
     * operation to set the flag to <code>false</code>. The QLDB console disables deletion protection for you when you
     * use it to delete a ledger.
     * </p>
     * 
     * @return The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this
     *         feature is enabled (<code>true</code>) by default.</p>
     *         <p>
     *         If deletion protection is enabled, you must first disable it before you can delete the ledger using the
     *         QLDB API or the AWS Command Line Interface (AWS CLI). You can disable it by calling the
     *         <code>UpdateLedger</code> operation to set the flag to <code>false</code>. The QLDB console disables
     *         deletion protection for you when you use it to delete a ledger.
     */
    public Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLedgerRequest)) {
            return false;
        }
        CreateLedgerRequest other = (CreateLedgerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(tags(), other.tags())
                && Objects.equals(permissionsModeAsString(), other.permissionsModeAsString())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLedgerRequest").add("Name", name()).add("Tags", tags())
                .add("PermissionsMode", permissionsModeAsString()).add("DeletionProtection", deletionProtection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PermissionsMode":
            return Optional.ofNullable(clazz.cast(permissionsModeAsString()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLedgerRequest, T> g) {
        return obj -> g.apply((CreateLedgerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLedgerRequest> {
        /**
         * <p>
         * The name of the ledger that you want to create. The name must be unique among all of your ledgers in the
         * current AWS Region.
         * </p>
         * 
         * @param name
         *        The name of the ledger that you want to create. The name must be unique among all of your ledgers in
         *        the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive. Tag
         * values are case sensitive and can be null.
         * </p>
         * 
         * @param tags
         *        The key-value pairs to add as tags to the ledger that you want to create. Tag keys are case sensitive.
         *        Tag values are case sensitive and can be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The permissions mode to assign to the ledger that you want to create.
         * </p>
         * 
         * @param permissionsMode
         *        The permissions mode to assign to the ledger that you want to create.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(String permissionsMode);

        /**
         * <p>
         * The permissions mode to assign to the ledger that you want to create.
         * </p>
         * 
         * @param permissionsMode
         *        The permissions mode to assign to the ledger that you want to create.
         * @see PermissionsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionsMode
         */
        Builder permissionsMode(PermissionsMode permissionsMode);

        /**
         * <p>
         * The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this
         * feature is enabled (<code>true</code>) by default.
         * </p>
         * <p>
         * If deletion protection is enabled, you must first disable it before you can delete the ledger using the QLDB
         * API or the AWS Command Line Interface (AWS CLI). You can disable it by calling the <code>UpdateLedger</code>
         * operation to set the flag to <code>false</code>. The QLDB console disables deletion protection for you when
         * you use it to delete a ledger.
         * </p>
         * 
         * @param deletionProtection
         *        The flag that prevents a ledger from being deleted by any user. If not provided on ledger creation,
         *        this feature is enabled (<code>true</code>) by default.</p>
         *        <p>
         *        If deletion protection is enabled, you must first disable it before you can delete the ledger using
         *        the QLDB API or the AWS Command Line Interface (AWS CLI). You can disable it by calling the
         *        <code>UpdateLedger</code> operation to set the flag to <code>false</code>. The QLDB console disables
         *        deletion protection for you when you use it to delete a ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QldbRequest.BuilderImpl implements Builder {
        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String permissionsMode;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLedgerRequest model) {
            super(model);
            name(model.name);
            tags(model.tags);
            permissionsMode(model.permissionsMode);
            deletionProtection(model.deletionProtection);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getPermissionsMode() {
            return permissionsMode;
        }

        @Override
        public final Builder permissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
            return this;
        }

        @Override
        public final Builder permissionsMode(PermissionsMode permissionsMode) {
            this.permissionsMode(permissionsMode == null ? null : permissionsMode.toString());
            return this;
        }

        public final void setPermissionsMode(String permissionsMode) {
            this.permissionsMode = permissionsMode;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLedgerRequest build() {
            return new CreateLedgerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
