/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRevisionResponse extends QldbResponse implements
        ToCopyableBuilder<GetRevisionResponse.Builder, GetRevisionResponse> {
    private static final SdkField<ValueHolder> PROOF_FIELD = SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRevisionResponse::proof)).setter(setter(Builder::proof)).constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proof").build()).build();

    private static final SdkField<ValueHolder> REVISION_FIELD = SdkField.<ValueHolder> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetRevisionResponse::revision)).setter(setter(Builder::revision)).constructor(ValueHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROOF_FIELD, REVISION_FIELD));

    private final ValueHolder proof;

    private final ValueHolder revision;

    private GetRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.proof = builder.proof;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains the list
     * of hash values that are required to recalculate the specified digest using a Merkle tree, starting with the
     * specified document revision.
     * </p>
     * 
     * @return The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains
     *         the list of hash values that are required to recalculate the specified digest using a Merkle tree,
     *         starting with the specified document revision.
     */
    public ValueHolder proof() {
        return proof;
    }

    /**
     * <p>
     * The document revision data object in Amazon Ion format.
     * </p>
     * 
     * @return The document revision data object in Amazon Ion format.
     */
    public ValueHolder revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proof());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevisionResponse)) {
            return false;
        }
        GetRevisionResponse other = (GetRevisionResponse) obj;
        return Objects.equals(proof(), other.proof()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRevisionResponse").add("Proof", proof() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Revision", revision() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Proof":
            return Optional.ofNullable(clazz.cast(proof()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRevisionResponse, T> g) {
        return obj -> g.apply((GetRevisionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QldbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRevisionResponse> {
        /**
         * <p>
         * The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains the
         * list of hash values that are required to recalculate the specified digest using a Merkle tree, starting with
         * the specified document revision.
         * </p>
         * 
         * @param proof
         *        The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains
         *        the list of hash values that are required to recalculate the specified digest using a Merkle tree,
         *        starting with the specified document revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proof(ValueHolder proof);

        /**
         * <p>
         * The proof object in Amazon Ion format returned by a <code>GetRevision</code> request. A proof contains the
         * list of hash values that are required to recalculate the specified digest using a Merkle tree, starting with
         * the specified document revision.
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #proof(ValueHolder)}.
         * 
         * @param proof
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proof(ValueHolder)
         */
        default Builder proof(Consumer<ValueHolder.Builder> proof) {
            return proof(ValueHolder.builder().applyMutation(proof).build());
        }

        /**
         * <p>
         * The document revision data object in Amazon Ion format.
         * </p>
         * 
         * @param revision
         *        The document revision data object in Amazon Ion format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(ValueHolder revision);

        /**
         * <p>
         * The document revision data object in Amazon Ion format.
         * </p>
         * This is a convenience that creates an instance of the {@link ValueHolder.Builder} avoiding the need to create
         * one manually via {@link ValueHolder#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValueHolder.Builder#build()} is called immediately and its result
         * is passed to {@link #revision(ValueHolder)}.
         * 
         * @param revision
         *        a consumer that will call methods on {@link ValueHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revision(ValueHolder)
         */
        default Builder revision(Consumer<ValueHolder.Builder> revision) {
            return revision(ValueHolder.builder().applyMutation(revision).build());
        }
    }

    static final class BuilderImpl extends QldbResponse.BuilderImpl implements Builder {
        private ValueHolder proof;

        private ValueHolder revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRevisionResponse model) {
            super(model);
            proof(model.proof);
            revision(model.revision);
        }

        public final ValueHolder.Builder getProof() {
            return proof != null ? proof.toBuilder() : null;
        }

        @Override
        public final Builder proof(ValueHolder proof) {
            this.proof = proof;
            return this;
        }

        public final void setProof(ValueHolder.BuilderImpl proof) {
            this.proof = proof != null ? proof.build() : null;
        }

        public final ValueHolder.Builder getRevision() {
            return revision != null ? revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(ValueHolder revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(ValueHolder.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public GetRevisionResponse build() {
            return new GetRevisionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
