/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationType {
    KNOWLEDGE_CONTENT("KNOWLEDGE_CONTENT"),
    GENERATIVE_RESPONSE("GENERATIVE_RESPONSE"),
    GENERATIVE_ANSWER("GENERATIVE_ANSWER"),
    DETECTED_INTENT("DETECTED_INTENT"),
    GENERATIVE_ANSWER_CHUNK("GENERATIVE_ANSWER_CHUNK"),
    BLOCKED_GENERATIVE_ANSWER_CHUNK("BLOCKED_GENERATIVE_ANSWER_CHUNK"),
    INTENT_ANSWER_CHUNK("INTENT_ANSWER_CHUNK"),
    BLOCKED_INTENT_ANSWER_CHUNK("BLOCKED_INTENT_ANSWER_CHUNK"),
    EMAIL_RESPONSE_CHUNK("EMAIL_RESPONSE_CHUNK"),
    EMAIL_OVERVIEW_CHUNK("EMAIL_OVERVIEW_CHUNK"),
    EMAIL_GENERATIVE_ANSWER_CHUNK("EMAIL_GENERATIVE_ANSWER_CHUNK"),
    CASE_SUMMARIZATION_CHUNK("CASE_SUMMARIZATION_CHUNK"),
    BLOCKED_CASE_SUMMARIZATION_CHUNK("BLOCKED_CASE_SUMMARIZATION_CHUNK"),
    SUGGESTED_MESSAGE("SUGGESTED_MESSAGE"),
    NOTES_CHUNK("NOTES_CHUNK"),
    BLOCKED_NOTES_CHUNK("BLOCKED_NOTES_CHUNK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationType> VALUE_MAP;
    private final String value;

    private RecommendationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationType> knownValues() {
        EnumSet<RecommendationType> knownValues = EnumSet.allOf(RecommendationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationType.class, RecommendationType::toString);
    }
}

