/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalBedrockKnowledgeBaseConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalBedrockKnowledgeBaseConfig> {
    private static final SdkField<String> BEDROCK_KNOWLEDGE_BASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bedrockKnowledgeBaseArn").getter(ExternalBedrockKnowledgeBaseConfig.getter(ExternalBedrockKnowledgeBaseConfig::bedrockKnowledgeBaseArn)).setter(ExternalBedrockKnowledgeBaseConfig.setter(Builder::bedrockKnowledgeBaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeBaseArn").build()}).build();
    private static final SdkField<String> ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessRoleArn").getter(ExternalBedrockKnowledgeBaseConfig.getter(ExternalBedrockKnowledgeBaseConfig::accessRoleArn)).setter(ExternalBedrockKnowledgeBaseConfig.setter(Builder::accessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_KNOWLEDGE_BASE_ARN_FIELD, ACCESS_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalBedrockKnowledgeBaseConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bedrockKnowledgeBaseArn;
    private final String accessRoleArn;

    private ExternalBedrockKnowledgeBaseConfig(BuilderImpl builder) {
        this.bedrockKnowledgeBaseArn = builder.bedrockKnowledgeBaseArn;
        this.accessRoleArn = builder.accessRoleArn;
    }

    public final String bedrockKnowledgeBaseArn() {
        return this.bedrockKnowledgeBaseArn;
    }

    public final String accessRoleArn() {
        return this.accessRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockKnowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalBedrockKnowledgeBaseConfig)) {
            return false;
        }
        ExternalBedrockKnowledgeBaseConfig other = (ExternalBedrockKnowledgeBaseConfig)obj;
        return Objects.equals(this.bedrockKnowledgeBaseArn(), other.bedrockKnowledgeBaseArn()) && Objects.equals(this.accessRoleArn(), other.accessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalBedrockKnowledgeBaseConfig").add("BedrockKnowledgeBaseArn", (Object)this.bedrockKnowledgeBaseArn()).add("AccessRoleArn", (Object)this.accessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bedrockKnowledgeBaseArn": {
                return Optional.ofNullable(clazz.cast(this.bedrockKnowledgeBaseArn()));
            }
            case "accessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.accessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bedrockKnowledgeBaseArn", BEDROCK_KNOWLEDGE_BASE_ARN_FIELD);
        map.put("accessRoleArn", ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalBedrockKnowledgeBaseConfig, T> g) {
        return obj -> g.apply((ExternalBedrockKnowledgeBaseConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bedrockKnowledgeBaseArn;
        private String accessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalBedrockKnowledgeBaseConfig model) {
            this.bedrockKnowledgeBaseArn(model.bedrockKnowledgeBaseArn);
            this.accessRoleArn(model.accessRoleArn);
        }

        public final String getBedrockKnowledgeBaseArn() {
            return this.bedrockKnowledgeBaseArn;
        }

        public final void setBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
        }

        @Override
        public final Builder bedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
            this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
            return this;
        }

        public final String getAccessRoleArn() {
            return this.accessRoleArn;
        }

        public final void setAccessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
        }

        @Override
        public final Builder accessRoleArn(String accessRoleArn) {
            this.accessRoleArn = accessRoleArn;
            return this;
        }

        public ExternalBedrockKnowledgeBaseConfig build() {
            return new ExternalBedrockKnowledgeBaseConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalBedrockKnowledgeBaseConfig> {
        public Builder bedrockKnowledgeBaseArn(String var1);

        public Builder accessRoleArn(String var1);
    }
}

