/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AssociationConfiguration;
import software.amazon.awssdk.services.qconnect.model.AssociationConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailResponseAIAgentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailResponseAIAgentConfiguration> {
    private static final SdkField<String> EMAIL_RESPONSE_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailResponseAIPromptId").getter(EmailResponseAIAgentConfiguration.getter(EmailResponseAIAgentConfiguration::emailResponseAIPromptId)).setter(EmailResponseAIAgentConfiguration.setter(Builder::emailResponseAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailResponseAIPromptId").build()}).build();
    private static final SdkField<String> EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailQueryReformulationAIPromptId").getter(EmailResponseAIAgentConfiguration.getter(EmailResponseAIAgentConfiguration::emailQueryReformulationAIPromptId)).setter(EmailResponseAIAgentConfiguration.setter(Builder::emailQueryReformulationAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailQueryReformulationAIPromptId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(EmailResponseAIAgentConfiguration.getter(EmailResponseAIAgentConfiguration::locale)).setter(EmailResponseAIAgentConfiguration.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associationConfigurations").getter(EmailResponseAIAgentConfiguration.getter(EmailResponseAIAgentConfiguration::associationConfigurations)).setter(EmailResponseAIAgentConfiguration.setter(Builder::associationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_RESPONSE_AI_PROMPT_ID_FIELD, EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD, LOCALE_FIELD, ASSOCIATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailResponseAIAgentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String emailResponseAIPromptId;
    private final String emailQueryReformulationAIPromptId;
    private final String locale;
    private final List<AssociationConfiguration> associationConfigurations;

    private EmailResponseAIAgentConfiguration(BuilderImpl builder) {
        this.emailResponseAIPromptId = builder.emailResponseAIPromptId;
        this.emailQueryReformulationAIPromptId = builder.emailQueryReformulationAIPromptId;
        this.locale = builder.locale;
        this.associationConfigurations = builder.associationConfigurations;
    }

    public final String emailResponseAIPromptId() {
        return this.emailResponseAIPromptId;
    }

    public final String emailQueryReformulationAIPromptId() {
        return this.emailQueryReformulationAIPromptId;
    }

    public final String locale() {
        return this.locale;
    }

    public final boolean hasAssociationConfigurations() {
        return this.associationConfigurations != null && !(this.associationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AssociationConfiguration> associationConfigurations() {
        return this.associationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailResponseAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailQueryReformulationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationConfigurations() ? this.associationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailResponseAIAgentConfiguration)) {
            return false;
        }
        EmailResponseAIAgentConfiguration other = (EmailResponseAIAgentConfiguration)obj;
        return Objects.equals(this.emailResponseAIPromptId(), other.emailResponseAIPromptId()) && Objects.equals(this.emailQueryReformulationAIPromptId(), other.emailQueryReformulationAIPromptId()) && Objects.equals(this.locale(), other.locale()) && this.hasAssociationConfigurations() == other.hasAssociationConfigurations() && Objects.equals(this.associationConfigurations(), other.associationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"EmailResponseAIAgentConfiguration").add("EmailResponseAIPromptId", (Object)this.emailResponseAIPromptId()).add("EmailQueryReformulationAIPromptId", (Object)this.emailQueryReformulationAIPromptId()).add("Locale", (Object)this.locale()).add("AssociationConfigurations", this.hasAssociationConfigurations() ? this.associationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "emailResponseAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.emailResponseAIPromptId()));
            }
            case "emailQueryReformulationAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.emailQueryReformulationAIPromptId()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "associationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.associationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("emailResponseAIPromptId", EMAIL_RESPONSE_AI_PROMPT_ID_FIELD);
        map.put("emailQueryReformulationAIPromptId", EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("associationConfigurations", ASSOCIATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailResponseAIAgentConfiguration, T> g) {
        return obj -> g.apply((EmailResponseAIAgentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailResponseAIPromptId;
        private String emailQueryReformulationAIPromptId;
        private String locale;
        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailResponseAIAgentConfiguration model) {
            this.emailResponseAIPromptId(model.emailResponseAIPromptId);
            this.emailQueryReformulationAIPromptId(model.emailQueryReformulationAIPromptId);
            this.locale(model.locale);
            this.associationConfigurations(model.associationConfigurations);
        }

        public final String getEmailResponseAIPromptId() {
            return this.emailResponseAIPromptId;
        }

        public final void setEmailResponseAIPromptId(String emailResponseAIPromptId) {
            this.emailResponseAIPromptId = emailResponseAIPromptId;
        }

        @Override
        public final Builder emailResponseAIPromptId(String emailResponseAIPromptId) {
            this.emailResponseAIPromptId = emailResponseAIPromptId;
            return this;
        }

        public final String getEmailQueryReformulationAIPromptId() {
            return this.emailQueryReformulationAIPromptId;
        }

        public final void setEmailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
        }

        @Override
        public final Builder emailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier.copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration ... associationConfigurations) {
            this.associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... associationConfigurations) {
            this.associationConfigurations(Stream.of(associationConfigurations).map(c -> (AssociationConfiguration)((AssociationConfiguration.Builder)AssociationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EmailResponseAIAgentConfiguration build() {
            return new EmailResponseAIAgentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailResponseAIAgentConfiguration> {
        public Builder emailResponseAIPromptId(String var1);

        public Builder emailQueryReformulationAIPromptId(String var1);

        public Builder locale(String var1);

        public Builder associationConfigurations(Collection<AssociationConfiguration> var1);

        public Builder associationConfigurations(AssociationConfiguration ... var1);

        public Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... var1);
    }
}

