/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AssociationConfiguration;
import software.amazon.awssdk.services.qconnect.model.AssociationConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailGenerativeAnswerAIAgentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailGenerativeAnswerAIAgentConfiguration> {
    private static final SdkField<String> EMAIL_GENERATIVE_ANSWER_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailGenerativeAnswerAIPromptId").getter(EmailGenerativeAnswerAIAgentConfiguration.getter(EmailGenerativeAnswerAIAgentConfiguration::emailGenerativeAnswerAIPromptId)).setter(EmailGenerativeAnswerAIAgentConfiguration.setter(Builder::emailGenerativeAnswerAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailGenerativeAnswerAIPromptId").build()}).build();
    private static final SdkField<String> EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("emailQueryReformulationAIPromptId").getter(EmailGenerativeAnswerAIAgentConfiguration.getter(EmailGenerativeAnswerAIAgentConfiguration::emailQueryReformulationAIPromptId)).setter(EmailGenerativeAnswerAIAgentConfiguration.setter(Builder::emailQueryReformulationAIPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailQueryReformulationAIPromptId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(EmailGenerativeAnswerAIAgentConfiguration.getter(EmailGenerativeAnswerAIAgentConfiguration::locale)).setter(EmailGenerativeAnswerAIAgentConfiguration.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<List<AssociationConfiguration>> ASSOCIATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associationConfigurations").getter(EmailGenerativeAnswerAIAgentConfiguration.getter(EmailGenerativeAnswerAIAgentConfiguration::associationConfigurations)).setter(EmailGenerativeAnswerAIAgentConfiguration.setter(Builder::associationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_GENERATIVE_ANSWER_AI_PROMPT_ID_FIELD, EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD, LOCALE_FIELD, ASSOCIATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailGenerativeAnswerAIAgentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String emailGenerativeAnswerAIPromptId;
    private final String emailQueryReformulationAIPromptId;
    private final String locale;
    private final List<AssociationConfiguration> associationConfigurations;

    private EmailGenerativeAnswerAIAgentConfiguration(BuilderImpl builder) {
        this.emailGenerativeAnswerAIPromptId = builder.emailGenerativeAnswerAIPromptId;
        this.emailQueryReformulationAIPromptId = builder.emailQueryReformulationAIPromptId;
        this.locale = builder.locale;
        this.associationConfigurations = builder.associationConfigurations;
    }

    public final String emailGenerativeAnswerAIPromptId() {
        return this.emailGenerativeAnswerAIPromptId;
    }

    public final String emailQueryReformulationAIPromptId() {
        return this.emailQueryReformulationAIPromptId;
    }

    public final String locale() {
        return this.locale;
    }

    public final boolean hasAssociationConfigurations() {
        return this.associationConfigurations != null && !(this.associationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AssociationConfiguration> associationConfigurations() {
        return this.associationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailGenerativeAnswerAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailQueryReformulationAIPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationConfigurations() ? this.associationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailGenerativeAnswerAIAgentConfiguration)) {
            return false;
        }
        EmailGenerativeAnswerAIAgentConfiguration other = (EmailGenerativeAnswerAIAgentConfiguration)obj;
        return Objects.equals(this.emailGenerativeAnswerAIPromptId(), other.emailGenerativeAnswerAIPromptId()) && Objects.equals(this.emailQueryReformulationAIPromptId(), other.emailQueryReformulationAIPromptId()) && Objects.equals(this.locale(), other.locale()) && this.hasAssociationConfigurations() == other.hasAssociationConfigurations() && Objects.equals(this.associationConfigurations(), other.associationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"EmailGenerativeAnswerAIAgentConfiguration").add("EmailGenerativeAnswerAIPromptId", (Object)this.emailGenerativeAnswerAIPromptId()).add("EmailQueryReformulationAIPromptId", (Object)this.emailQueryReformulationAIPromptId()).add("Locale", (Object)this.locale()).add("AssociationConfigurations", this.hasAssociationConfigurations() ? this.associationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "emailGenerativeAnswerAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.emailGenerativeAnswerAIPromptId()));
            }
            case "emailQueryReformulationAIPromptId": {
                return Optional.ofNullable(clazz.cast(this.emailQueryReformulationAIPromptId()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "associationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.associationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("emailGenerativeAnswerAIPromptId", EMAIL_GENERATIVE_ANSWER_AI_PROMPT_ID_FIELD);
        map.put("emailQueryReformulationAIPromptId", EMAIL_QUERY_REFORMULATION_AI_PROMPT_ID_FIELD);
        map.put("locale", LOCALE_FIELD);
        map.put("associationConfigurations", ASSOCIATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailGenerativeAnswerAIAgentConfiguration, T> g) {
        return obj -> g.apply((EmailGenerativeAnswerAIAgentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailGenerativeAnswerAIPromptId;
        private String emailQueryReformulationAIPromptId;
        private String locale;
        private List<AssociationConfiguration> associationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailGenerativeAnswerAIAgentConfiguration model) {
            this.emailGenerativeAnswerAIPromptId(model.emailGenerativeAnswerAIPromptId);
            this.emailQueryReformulationAIPromptId(model.emailQueryReformulationAIPromptId);
            this.locale(model.locale);
            this.associationConfigurations(model.associationConfigurations);
        }

        public final String getEmailGenerativeAnswerAIPromptId() {
            return this.emailGenerativeAnswerAIPromptId;
        }

        public final void setEmailGenerativeAnswerAIPromptId(String emailGenerativeAnswerAIPromptId) {
            this.emailGenerativeAnswerAIPromptId = emailGenerativeAnswerAIPromptId;
        }

        @Override
        public final Builder emailGenerativeAnswerAIPromptId(String emailGenerativeAnswerAIPromptId) {
            this.emailGenerativeAnswerAIPromptId = emailGenerativeAnswerAIPromptId;
            return this;
        }

        public final String getEmailQueryReformulationAIPromptId() {
            return this.emailQueryReformulationAIPromptId;
        }

        public final void setEmailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
        }

        @Override
        public final Builder emailQueryReformulationAIPromptId(String emailQueryReformulationAIPromptId) {
            this.emailQueryReformulationAIPromptId = emailQueryReformulationAIPromptId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final List<AssociationConfiguration.Builder> getAssociationConfigurations() {
            List<AssociationConfiguration.Builder> result = AssociationConfigurationListCopier.copyToBuilder(this.associationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationConfigurations(Collection<AssociationConfiguration.BuilderImpl> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copyFromBuilder(associationConfigurations);
        }

        @Override
        public final Builder associationConfigurations(Collection<AssociationConfiguration> associationConfigurations) {
            this.associationConfigurations = AssociationConfigurationListCopier.copy(associationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(AssociationConfiguration ... associationConfigurations) {
            this.associationConfigurations(Arrays.asList(associationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... associationConfigurations) {
            this.associationConfigurations(Stream.of(associationConfigurations).map(c -> (AssociationConfiguration)((AssociationConfiguration.Builder)AssociationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EmailGenerativeAnswerAIAgentConfiguration build() {
            return new EmailGenerativeAnswerAIAgentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailGenerativeAnswerAIAgentConfiguration> {
        public Builder emailGenerativeAnswerAIPromptId(String var1);

        public Builder emailQueryReformulationAIPromptId(String var1);

        public Builder locale(String var1);

        public Builder associationConfigurations(Collection<AssociationConfiguration> var1);

        public Builder associationConfigurations(AssociationConfiguration ... var1);

        public Builder associationConfigurations(Consumer<AssociationConfiguration.Builder> ... var1);
    }
}

