/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AIPromptAPIFormat;
import software.amazon.awssdk.services.qconnect.model.AIPromptInferenceConfiguration;
import software.amazon.awssdk.services.qconnect.model.AIPromptTemplateConfiguration;
import software.amazon.awssdk.services.qconnect.model.AIPromptTemplateType;
import software.amazon.awssdk.services.qconnect.model.AIPromptType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAiPromptRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, CreateAiPromptRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::clientToken)).setter(CreateAiPromptRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::assistantId)).setter(CreateAiPromptRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::name)).setter(CreateAiPromptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::typeAsString)).setter(CreateAiPromptRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateConfiguration").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::templateConfiguration)).setter(CreateAiPromptRequest.setter(Builder::templateConfiguration)).constructor(AIPromptTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::visibilityStatusAsString)).setter(CreateAiPromptRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::templateTypeAsString)).setter(CreateAiPromptRequest.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::modelId)).setter(CreateAiPromptRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> API_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiFormat").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::apiFormatAsString)).setter(CreateAiPromptRequest.setter(Builder::apiFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiFormat").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::tags)).setter(CreateAiPromptRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::description)).setter(CreateAiPromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AIPromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(CreateAiPromptRequest.getter(CreateAiPromptRequest::inferenceConfiguration)).setter(CreateAiPromptRequest.setter(Builder::inferenceConfiguration)).constructor(AIPromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ASSISTANT_ID_FIELD, NAME_FIELD, TYPE_FIELD, TEMPLATE_CONFIGURATION_FIELD, VISIBILITY_STATUS_FIELD, TEMPLATE_TYPE_FIELD, MODEL_ID_FIELD, API_FORMAT_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, INFERENCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAiPromptRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String assistantId;
    private final String name;
    private final String type;
    private final AIPromptTemplateConfiguration templateConfiguration;
    private final String visibilityStatus;
    private final String templateType;
    private final String modelId;
    private final String apiFormat;
    private final Map<String, String> tags;
    private final String description;
    private final AIPromptInferenceConfiguration inferenceConfiguration;

    private CreateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.name = builder.name;
        this.type = builder.type;
        this.templateConfiguration = builder.templateConfiguration;
        this.visibilityStatus = builder.visibilityStatus;
        this.templateType = builder.templateType;
        this.modelId = builder.modelId;
        this.apiFormat = builder.apiFormat;
        this.tags = builder.tags;
        this.description = builder.description;
        this.inferenceConfiguration = builder.inferenceConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String name() {
        return this.name;
    }

    public final AIPromptType type() {
        return AIPromptType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final AIPromptTemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final AIPromptTemplateType templateType() {
        return AIPromptTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final AIPromptAPIFormat apiFormat() {
        return AIPromptAPIFormat.fromValue(this.apiFormat);
    }

    public final String apiFormatAsString() {
        return this.apiFormat;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String description() {
        return this.description;
    }

    public final AIPromptInferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAiPromptRequest)) {
            return false;
        }
        CreateAiPromptRequest other = (CreateAiPromptRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.apiFormatAsString(), other.apiFormatAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAiPromptRequest").add("ClientToken", (Object)this.clientToken()).add("AssistantId", (Object)this.assistantId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("TemplateType", (Object)this.templateTypeAsString()).add("ModelId", (Object)this.modelId()).add("ApiFormat", (Object)this.apiFormatAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "templateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "apiFormat": {
                return Optional.ofNullable(clazz.cast(this.apiFormatAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("apiFormat", API_FORMAT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAiPromptRequest, T> g) {
        return obj -> g.apply((CreateAiPromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String assistantId;
        private String name;
        private String type;
        private AIPromptTemplateConfiguration templateConfiguration;
        private String visibilityStatus;
        private String templateType;
        private String modelId;
        private String apiFormat;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private AIPromptInferenceConfiguration inferenceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAiPromptRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.assistantId(model.assistantId);
            this.name(model.name);
            this.type(model.type);
            this.templateConfiguration(model.templateConfiguration);
            this.visibilityStatus(model.visibilityStatus);
            this.templateType(model.templateType);
            this.modelId(model.modelId);
            this.apiFormat(model.apiFormat);
            this.tags(model.tags);
            this.description(model.description);
            this.inferenceConfiguration(model.inferenceConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AIPromptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(AIPromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getApiFormat() {
            return this.apiFormat;
        }

        public final void setApiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
        }

        @Override
        public final Builder apiFormat(String apiFormat) {
            this.apiFormat = apiFormat;
            return this;
        }

        @Override
        public final Builder apiFormat(AIPromptAPIFormat apiFormat) {
            this.apiFormat(apiFormat == null ? null : apiFormat.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIPromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(AIPromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAiPromptRequest build() {
            return new CreateAiPromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAiPromptRequest> {
        public Builder clientToken(String var1);

        public Builder assistantId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(AIPromptType var1);

        public Builder templateConfiguration(AIPromptTemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((AIPromptTemplateConfiguration)((AIPromptTemplateConfiguration.Builder)AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder templateType(String var1);

        public Builder templateType(AIPromptTemplateType var1);

        public Builder modelId(String var1);

        public Builder apiFormat(String var1);

        public Builder apiFormat(AIPromptAPIFormat var1);

        public Builder tags(Map<String, String> var1);

        public Builder description(String var1);

        public Builder inferenceConfiguration(AIPromptInferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<AIPromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((AIPromptInferenceConfiguration)((AIPromptInferenceConfiguration.Builder)AIPromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

