/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.CitationSpan;
import software.amazon.awssdk.services.qconnect.model.ReferenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Citation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Citation> {
    private static final SdkField<String> CONTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentId").getter(Citation.getter(Citation::contentId)).setter(Citation.setter(Builder::contentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(Citation.getter(Citation::title)).setter(Citation.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(Citation.getter(Citation::knowledgeBaseId)).setter(Citation.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<CitationSpan> CITATION_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citationSpan").getter(Citation.getter(Citation::citationSpan)).setter(Citation.setter(Builder::citationSpan)).constructor(CitationSpan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citationSpan").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceURL").getter(Citation.getter(Citation::sourceURL)).setter(Citation.setter(Builder::sourceURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceURL").build()}).build();
    private static final SdkField<String> REFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceType").getter(Citation.getter(Citation::referenceTypeAsString)).setter(Citation.setter(Builder::referenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ID_FIELD, TITLE_FIELD, KNOWLEDGE_BASE_ID_FIELD, CITATION_SPAN_FIELD, SOURCE_URL_FIELD, REFERENCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Citation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contentId;
    private final String title;
    private final String knowledgeBaseId;
    private final CitationSpan citationSpan;
    private final String sourceURL;
    private final String referenceType;

    private Citation(BuilderImpl builder) {
        this.contentId = builder.contentId;
        this.title = builder.title;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.citationSpan = builder.citationSpan;
        this.sourceURL = builder.sourceURL;
        this.referenceType = builder.referenceType;
    }

    public final String contentId() {
        return this.contentId;
    }

    public final String title() {
        return this.title;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final CitationSpan citationSpan() {
        return this.citationSpan;
    }

    public final String sourceURL() {
        return this.sourceURL;
    }

    public final ReferenceType referenceType() {
        return ReferenceType.fromValue(this.referenceType);
    }

    public final String referenceTypeAsString() {
        return this.referenceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.citationSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation)obj;
        return Objects.equals(this.contentId(), other.contentId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.citationSpan(), other.citationSpan()) && Objects.equals(this.sourceURL(), other.sourceURL()) && Objects.equals(this.referenceTypeAsString(), other.referenceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Citation").add("ContentId", (Object)this.contentId()).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("CitationSpan", (Object)this.citationSpan()).add("SourceURL", (Object)(this.sourceURL() == null ? null : "*** Sensitive Data Redacted ***")).add("ReferenceType", (Object)this.referenceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentId": {
                return Optional.ofNullable(clazz.cast(this.contentId()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "citationSpan": {
                return Optional.ofNullable(clazz.cast(this.citationSpan()));
            }
            case "sourceURL": {
                return Optional.ofNullable(clazz.cast(this.sourceURL()));
            }
            case "referenceType": {
                return Optional.ofNullable(clazz.cast(this.referenceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentId", CONTENT_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("citationSpan", CITATION_SPAN_FIELD);
        map.put("sourceURL", SOURCE_URL_FIELD);
        map.put("referenceType", REFERENCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Citation, T> g) {
        return obj -> g.apply((Citation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentId;
        private String title;
        private String knowledgeBaseId;
        private CitationSpan citationSpan;
        private String sourceURL;
        private String referenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Citation model) {
            this.contentId(model.contentId);
            this.title(model.title);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.citationSpan(model.citationSpan);
            this.sourceURL(model.sourceURL);
            this.referenceType(model.referenceType);
        }

        public final String getContentId() {
            return this.contentId;
        }

        public final void setContentId(String contentId) {
            this.contentId = contentId;
        }

        @Override
        public final Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final CitationSpan.Builder getCitationSpan() {
            return this.citationSpan != null ? this.citationSpan.toBuilder() : null;
        }

        public final void setCitationSpan(CitationSpan.BuilderImpl citationSpan) {
            this.citationSpan = citationSpan != null ? citationSpan.build() : null;
        }

        @Override
        public final Builder citationSpan(CitationSpan citationSpan) {
            this.citationSpan = citationSpan;
            return this;
        }

        public final String getSourceURL() {
            return this.sourceURL;
        }

        public final void setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
        }

        @Override
        public final Builder sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        public final String getReferenceType() {
            return this.referenceType;
        }

        public final void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        @Override
        public final Builder referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Override
        public final Builder referenceType(ReferenceType referenceType) {
            this.referenceType(referenceType == null ? null : referenceType.toString());
            return this;
        }

        public Citation build() {
            return new Citation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Citation> {
        public Builder contentId(String var1);

        public Builder title(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder citationSpan(CitationSpan var1);

        default public Builder citationSpan(Consumer<CitationSpan.Builder> citationSpan) {
            return this.citationSpan((CitationSpan)((CitationSpan.Builder)CitationSpan.builder().applyMutation(citationSpan)).build());
        }

        public Builder sourceURL(String var1);

        public Builder referenceType(String var1);

        public Builder referenceType(ReferenceType var1);
    }
}

