/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about the external data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WhatsAppMessageTemplateSourceConfigurationSummary
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<WhatsAppMessageTemplateSourceConfigurationSummary.Builder, WhatsAppMessageTemplateSourceConfigurationSummary> {
    private static final SdkField<String> BUSINESS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessAccountId").getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::businessAccountId))
            .setter(setter(Builder::businessAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessAccountId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateId").getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::language))
            .setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("components")
            .getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::components))
            .setter(setter(Builder::components))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(WhatsAppMessageTemplateSourceConfigurationSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_ACCOUNT_ID_FIELD,
            TEMPLATE_ID_FIELD, NAME_FIELD, LANGUAGE_FIELD, COMPONENTS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String businessAccountId;

    private final String templateId;

    private final String name;

    private final String language;

    private final List<String> components;

    private final String status;

    private final String statusReason;

    private WhatsAppMessageTemplateSourceConfigurationSummary(BuilderImpl builder) {
        this.businessAccountId = builder.businessAccountId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.language = builder.language;
        this.components = builder.components;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The ID of the End User Messaging WhatsApp Business Account to associate with this template.
     * </p>
     * 
     * @return The ID of the End User Messaging WhatsApp Business Account to associate with this template.
     */
    public final String businessAccountId() {
        return businessAccountId;
    }

    /**
     * <p>
     * The ID of WhatsApp template.
     * </p>
     * 
     * @return The ID of WhatsApp template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the WhatsApp template.
     * </p>
     * 
     * @return The name of the WhatsApp template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The language of the WhatsApp template.
     * </p>
     * 
     * @return The language of the WhatsApp template.
     */
    public final String language() {
        return language;
    }

    /**
     * For responses, this returns true if the service returned a value for the Components property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasComponents() {
        return components != null && !(components instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of component mapping from WhatsApp template parameters to Message Template attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponents} method.
     * </p>
     * 
     * @return The list of component mapping from WhatsApp template parameters to Message Template attributes.
     */
    public final List<String> components() {
        return components;
    }

    /**
     * <p>
     * The status of the message template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WhatsAppSourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the message template.
     * @see WhatsAppSourceConfigurationStatus
     */
    public final WhatsAppSourceConfigurationStatus status() {
        return WhatsAppSourceConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the message template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WhatsAppSourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the message template.
     * @see WhatsAppSourceConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the message template.
     * </p>
     * 
     * @return The status reason of the message template.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponents() ? components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppMessageTemplateSourceConfigurationSummary)) {
            return false;
        }
        WhatsAppMessageTemplateSourceConfigurationSummary other = (WhatsAppMessageTemplateSourceConfigurationSummary) obj;
        return Objects.equals(businessAccountId(), other.businessAccountId()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(name(), other.name()) && Objects.equals(language(), other.language())
                && hasComponents() == other.hasComponents() && Objects.equals(components(), other.components())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WhatsAppMessageTemplateSourceConfigurationSummary")
                .add("BusinessAccountId", businessAccountId()).add("TemplateId", templateId()).add("Name", name())
                .add("Language", language()).add("Components", hasComponents() ? components() : null)
                .add("Status", statusAsString())
                .add("StatusReason", statusReason() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "businessAccountId":
            return Optional.ofNullable(clazz.cast(businessAccountId()));
        case "templateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "language":
            return Optional.ofNullable(clazz.cast(language()));
        case "components":
            return Optional.ofNullable(clazz.cast(components()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("businessAccountId", BUSINESS_ACCOUNT_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("components", COMPONENTS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppMessageTemplateSourceConfigurationSummary, T> g) {
        return obj -> g.apply((WhatsAppMessageTemplateSourceConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfigurationSummary> {
        /**
         * <p>
         * The ID of the End User Messaging WhatsApp Business Account to associate with this template.
         * </p>
         * 
         * @param businessAccountId
         *        The ID of the End User Messaging WhatsApp Business Account to associate with this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessAccountId(String businessAccountId);

        /**
         * <p>
         * The ID of WhatsApp template.
         * </p>
         * 
         * @param templateId
         *        The ID of WhatsApp template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the WhatsApp template.
         * </p>
         * 
         * @param name
         *        The name of the WhatsApp template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The language of the WhatsApp template.
         * </p>
         * 
         * @param language
         *        The language of the WhatsApp template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * </p>
         * 
         * @param components
         *        The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(Collection<String> components);

        /**
         * <p>
         * The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * </p>
         * 
         * @param components
         *        The list of component mapping from WhatsApp template parameters to Message Template attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder components(String... components);

        /**
         * <p>
         * The status of the message template.
         * </p>
         * 
         * @param status
         *        The status of the message template.
         * @see WhatsAppSourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WhatsAppSourceConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the message template.
         * </p>
         * 
         * @param status
         *        The status of the message template.
         * @see WhatsAppSourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WhatsAppSourceConfigurationStatus
         */
        Builder status(WhatsAppSourceConfigurationStatus status);

        /**
         * <p>
         * The status reason of the message template.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String businessAccountId;

        private String templateId;

        private String name;

        private String language;

        private List<String> components = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppMessageTemplateSourceConfigurationSummary model) {
            businessAccountId(model.businessAccountId);
            templateId(model.templateId);
            name(model.name);
            language(model.language);
            components(model.components);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getBusinessAccountId() {
            return businessAccountId;
        }

        public final void setBusinessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
        }

        @Override
        public final Builder businessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Collection<String> getComponents() {
            if (components instanceof SdkAutoConstructList) {
                return null;
            }
            return components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String... components) {
            components(Arrays.asList(components));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WhatsAppSourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public WhatsAppMessageTemplateSourceConfigurationSummary build() {
            return new WhatsAppMessageTemplateSourceConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
