/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssistantAiAgentRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateAssistantAiAgentRequest.Builder, UpdateAssistantAiAgentRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(UpdateAssistantAiAgentRequest::assistantId))
            .setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiAgentType").getter(getter(UpdateAssistantAiAgentRequest::aiAgentTypeAsString))
            .setter(setter(Builder::aiAgentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentType").build()).build();

    private static final SdkField<AIAgentConfigurationData> CONFIGURATION_FIELD = SdkField
            .<AIAgentConfigurationData> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateAssistantAiAgentRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AIAgentConfigurationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<OrchestratorConfigurationEntry>> ORCHESTRATOR_CONFIGURATION_LIST_FIELD = SdkField
            .<List<OrchestratorConfigurationEntry>> builder(MarshallingType.LIST)
            .memberName("orchestratorConfigurationList")
            .getter(getter(UpdateAssistantAiAgentRequest::orchestratorConfigurationList))
            .setter(setter(Builder::orchestratorConfigurationList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestratorConfigurationList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrchestratorConfigurationEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrchestratorConfigurationEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            AI_AGENT_TYPE_FIELD, CONFIGURATION_FIELD, ORCHESTRATOR_CONFIGURATION_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final String aiAgentType;

    private final AIAgentConfigurationData configuration;

    private final List<OrchestratorConfigurationEntry> orchestratorConfigurationList;

    private UpdateAssistantAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiAgentType = builder.aiAgentType;
        this.configuration = builder.configuration;
        this.orchestratorConfigurationList = builder.orchestratorConfigurationList;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(aiAgentType);
    }

    /**
     * <p>
     * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiAgentType} will
     * return {@link AIAgentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiAgentTypeAsString}.
     * </p>
     * 
     * @return The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * @see AIAgentType
     */
    public final String aiAgentTypeAsString() {
        return aiAgentType;
    }

    /**
     * <p>
     * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     * </p>
     * 
     * @return The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
     */
    public final AIAgentConfigurationData configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrchestratorConfigurationList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrchestratorConfigurationList() {
        return orchestratorConfigurationList != null && !(orchestratorConfigurationList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of orchestrator configurations for the assistant AI Agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrchestratorConfigurationList} method.
     * </p>
     * 
     * @return The updated list of orchestrator configurations for the assistant AI Agent.
     */
    public final List<OrchestratorConfigurationEntry> orchestratorConfigurationList() {
        return orchestratorConfigurationList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrchestratorConfigurationList() ? orchestratorConfigurationList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssistantAiAgentRequest)) {
            return false;
        }
        UpdateAssistantAiAgentRequest other = (UpdateAssistantAiAgentRequest) obj;
        return Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(aiAgentTypeAsString(), other.aiAgentTypeAsString())
                && Objects.equals(configuration(), other.configuration())
                && hasOrchestratorConfigurationList() == other.hasOrchestratorConfigurationList()
                && Objects.equals(orchestratorConfigurationList(), other.orchestratorConfigurationList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAssistantAiAgentRequest")
                .add("AssistantId", assistantId())
                .add("AiAgentType", aiAgentTypeAsString())
                .add("Configuration", configuration())
                .add("OrchestratorConfigurationList", hasOrchestratorConfigurationList() ? orchestratorConfigurationList() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "aiAgentType":
            return Optional.ofNullable(clazz.cast(aiAgentTypeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "orchestratorConfigurationList":
            return Optional.ofNullable(clazz.cast(orchestratorConfigurationList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("orchestratorConfigurationList", ORCHESTRATOR_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssistantAiAgentRequest, T> g) {
        return obj -> g.apply((UpdateAssistantAiAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssistantAiAgentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(String aiAgentType);

        /**
         * <p>
         * The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param aiAgentType
         *        The type of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * @see AIAgentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AIAgentType
         */
        Builder aiAgentType(AIAgentType aiAgentType);

        /**
         * <p>
         * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * 
         * @param configuration
         *        The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect
         *        Assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AIAgentConfigurationData configuration);

        /**
         * <p>
         * The configuration of the AI Agent being updated for use by default on the Amazon Q in Connect Assistant.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIAgentConfigurationData.Builder}
         * avoiding the need to create one manually via {@link AIAgentConfigurationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIAgentConfigurationData.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AIAgentConfigurationData)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AIAgentConfigurationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AIAgentConfigurationData)
         */
        default Builder configuration(Consumer<AIAgentConfigurationData.Builder> configuration) {
            return configuration(AIAgentConfigurationData.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The updated list of orchestrator configurations for the assistant AI Agent.
         * </p>
         * 
         * @param orchestratorConfigurationList
         *        The updated list of orchestrator configurations for the assistant AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorConfigurationList(Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList);

        /**
         * <p>
         * The updated list of orchestrator configurations for the assistant AI Agent.
         * </p>
         * 
         * @param orchestratorConfigurationList
         *        The updated list of orchestrator configurations for the assistant AI Agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestratorConfigurationList(OrchestratorConfigurationEntry... orchestratorConfigurationList);

        /**
         * <p>
         * The updated list of orchestrator configurations for the assistant AI Agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #orchestratorConfigurationList(List<OrchestratorConfigurationEntry>)}.
         * 
         * @param orchestratorConfigurationList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.OrchestratorConfigurationEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestratorConfigurationList(java.util.Collection<OrchestratorConfigurationEntry>)
         */
        Builder orchestratorConfigurationList(Consumer<OrchestratorConfigurationEntry.Builder>... orchestratorConfigurationList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private String aiAgentType;

        private AIAgentConfigurationData configuration;

        private List<OrchestratorConfigurationEntry> orchestratorConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssistantAiAgentRequest model) {
            super(model);
            assistantId(model.assistantId);
            aiAgentType(model.aiAgentType);
            configuration(model.configuration);
            orchestratorConfigurationList(model.orchestratorConfigurationList);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiAgentType() {
            return aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final AIAgentConfigurationData.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfigurationData.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfigurationData configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<OrchestratorConfigurationEntry.Builder> getOrchestratorConfigurationList() {
            List<OrchestratorConfigurationEntry.Builder> result = OrchestratorConfigurationListCopier
                    .copyToBuilder(this.orchestratorConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrchestratorConfigurationList(
                Collection<OrchestratorConfigurationEntry.BuilderImpl> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier
                    .copyFromBuilder(orchestratorConfigurationList);
        }

        @Override
        public final Builder orchestratorConfigurationList(
                Collection<OrchestratorConfigurationEntry> orchestratorConfigurationList) {
            this.orchestratorConfigurationList = OrchestratorConfigurationListCopier.copy(orchestratorConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(OrchestratorConfigurationEntry... orchestratorConfigurationList) {
            orchestratorConfigurationList(Arrays.asList(orchestratorConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orchestratorConfigurationList(
                Consumer<OrchestratorConfigurationEntry.Builder>... orchestratorConfigurationList) {
            orchestratorConfigurationList(Stream.of(orchestratorConfigurationList)
                    .map(c -> OrchestratorConfigurationEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssistantAiAgentRequest build() {
            return new UpdateAssistantAiAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
