/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for overriding tool input values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolOverrideInputValueConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolOverrideInputValueConfiguration.Builder, ToolOverrideInputValueConfiguration> {
    private static final SdkField<ToolOverrideConstantInputValue> CONSTANT_FIELD = SdkField
            .<ToolOverrideConstantInputValue> builder(MarshallingType.SDK_POJO).memberName("constant")
            .getter(getter(ToolOverrideInputValueConfiguration::constant)).setter(setter(Builder::constant))
            .constructor(ToolOverrideConstantInputValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ToolOverrideConstantInputValue constant;

    private final Type type;

    private ToolOverrideInputValueConfiguration(BuilderImpl builder) {
        this.constant = builder.constant;
        this.type = builder.type;
    }

    /**
     * <p>
     * Constant input value configuration for tool override.
     * </p>
     * 
     * @return Constant input value configuration for tool override.
     */
    public final ToolOverrideConstantInputValue constant() {
        return constant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOverrideInputValueConfiguration)) {
            return false;
        }
        ToolOverrideInputValueConfiguration other = (ToolOverrideInputValueConfiguration) obj;
        return Objects.equals(constant(), other.constant());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolOverrideInputValueConfiguration").add("Constant", constant()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "constant":
            return Optional.ofNullable(clazz.cast(constant()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #constant()} initialized to the given value.
     *
     * <p>
     * Constant input value configuration for tool override.
     * </p>
     * 
     * @param constant
     *        Constant input value configuration for tool override.
     */
    public static ToolOverrideInputValueConfiguration fromConstant(ToolOverrideConstantInputValue constant) {
        return builder().constant(constant).build();
    }

    /**
     * Create an instance of this class with {@link #constant()} initialized to the given value.
     *
     * <p>
     * Constant input value configuration for tool override.
     * </p>
     * 
     * @param constant
     *        Constant input value configuration for tool override.
     */
    public static ToolOverrideInputValueConfiguration fromConstant(Consumer<ToolOverrideConstantInputValue.Builder> constant) {
        ToolOverrideConstantInputValue.Builder builder = ToolOverrideConstantInputValue.builder();
        constant.accept(builder);
        return fromConstant(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("constant", CONSTANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolOverrideInputValueConfiguration, T> g) {
        return obj -> g.apply((ToolOverrideInputValueConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolOverrideInputValueConfiguration> {
        /**
         * <p>
         * Constant input value configuration for tool override.
         * </p>
         * 
         * @param constant
         *        Constant input value configuration for tool override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(ToolOverrideConstantInputValue constant);

        /**
         * <p>
         * Constant input value configuration for tool override.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolOverrideConstantInputValue.Builder}
         * avoiding the need to create one manually via {@link ToolOverrideConstantInputValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolOverrideConstantInputValue.Builder#build()} is called
         * immediately and its result is passed to {@link #constant(ToolOverrideConstantInputValue)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link ToolOverrideConstantInputValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(ToolOverrideConstantInputValue)
         */
        default Builder constant(Consumer<ToolOverrideConstantInputValue.Builder> constant) {
            return constant(ToolOverrideConstantInputValue.builder().applyMutation(constant).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ToolOverrideConstantInputValue constant;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolOverrideInputValueConfiguration model) {
            constant(model.constant);
        }

        public final ToolOverrideConstantInputValue.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(ToolOverrideConstantInputValue.BuilderImpl constant) {
            Object oldValue = this.constant;
            this.constant = constant != null ? constant.build() : null;
            handleUnionValueChange(Type.CONSTANT, oldValue, this.constant);
        }

        @Override
        public final Builder constant(ToolOverrideConstantInputValue constant) {
            Object oldValue = this.constant;
            this.constant = constant;
            handleUnionValueChange(Type.CONSTANT, oldValue, this.constant);
            return this;
        }

        @Override
        public ToolOverrideInputValueConfiguration build() {
            return new ToolOverrideInputValueConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ToolOverrideInputValueConfiguration#type()
     */
    public enum Type {
        CONSTANT,

        UNKNOWN_TO_SDK_VERSION
    }
}
