/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An input value override for tools.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolOverrideInputValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolOverrideInputValue.Builder, ToolOverrideInputValue> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jsonPath").getter(getter(ToolOverrideInputValue::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()).build();

    private static final SdkField<ToolOverrideInputValueConfiguration> VALUE_FIELD = SdkField
            .<ToolOverrideInputValueConfiguration> builder(MarshallingType.SDK_POJO).memberName("value")
            .getter(getter(ToolOverrideInputValue::value)).setter(setter(Builder::value))
            .constructor(ToolOverrideInputValueConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jsonPath;

    private final ToolOverrideInputValueConfiguration value;

    private ToolOverrideInputValue(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.value = builder.value;
    }

    /**
     * <p>
     * The JSON path for the input value override.
     * </p>
     * 
     * @return The JSON path for the input value override.
     */
    public final String jsonPath() {
        return jsonPath;
    }

    /**
     * <p>
     * The override input value.
     * </p>
     * 
     * @return The override input value.
     */
    public final ToolOverrideInputValueConfiguration value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOverrideInputValue)) {
            return false;
        }
        ToolOverrideInputValue other = (ToolOverrideInputValue) obj;
        return Objects.equals(jsonPath(), other.jsonPath()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolOverrideInputValue").add("JsonPath", jsonPath()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jsonPath", JSON_PATH_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolOverrideInputValue, T> g) {
        return obj -> g.apply((ToolOverrideInputValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolOverrideInputValue> {
        /**
         * <p>
         * The JSON path for the input value override.
         * </p>
         * 
         * @param jsonPath
         *        The JSON path for the input value override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);

        /**
         * <p>
         * The override input value.
         * </p>
         * 
         * @param value
         *        The override input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(ToolOverrideInputValueConfiguration value);

        /**
         * <p>
         * The override input value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ToolOverrideInputValueConfiguration.Builder} avoiding the need to create one manually via
         * {@link ToolOverrideInputValueConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolOverrideInputValueConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #value(ToolOverrideInputValueConfiguration)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link ToolOverrideInputValueConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(ToolOverrideInputValueConfiguration)
         */
        default Builder value(Consumer<ToolOverrideInputValueConfiguration.Builder> value) {
            return value(ToolOverrideInputValueConfiguration.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jsonPath;

        private ToolOverrideInputValueConfiguration value;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolOverrideInputValue model) {
            jsonPath(model.jsonPath);
            value(model.value);
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final ToolOverrideInputValueConfiguration.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(ToolOverrideInputValueConfiguration.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(ToolOverrideInputValueConfiguration value) {
            this.value = value;
            return this;
        }

        @Override
        public ToolOverrideInputValue build() {
            return new ToolOverrideInputValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
