/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for tool output handling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolOutputConfiguration.Builder, ToolOutputConfiguration> {
    private static final SdkField<String> OUTPUT_VARIABLE_NAME_OVERRIDE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("outputVariableNameOverride")
            .getter(getter(ToolOutputConfiguration::outputVariableNameOverride))
            .setter(setter(Builder::outputVariableNameOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariableNameOverride").build())
            .build();

    private static final SdkField<String> SESSION_DATA_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionDataNamespace").getter(getter(ToolOutputConfiguration::sessionDataNamespace))
            .setter(setter(Builder::sessionDataNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionDataNamespace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OUTPUT_VARIABLE_NAME_OVERRIDE_FIELD, SESSION_DATA_NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputVariableNameOverride;

    private final String sessionDataNamespace;

    private ToolOutputConfiguration(BuilderImpl builder) {
        this.outputVariableNameOverride = builder.outputVariableNameOverride;
        this.sessionDataNamespace = builder.sessionDataNamespace;
    }

    /**
     * <p>
     * Override the tool output results to different variable name.
     * </p>
     * 
     * @return Override the tool output results to different variable name.
     */
    public final String outputVariableNameOverride() {
        return outputVariableNameOverride;
    }

    /**
     * <p>
     * The session data namespace for tool output.
     * </p>
     * 
     * @return The session data namespace for tool output.
     */
    public final String sessionDataNamespace() {
        return sessionDataNamespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputVariableNameOverride());
        hashCode = 31 * hashCode + Objects.hashCode(sessionDataNamespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOutputConfiguration)) {
            return false;
        }
        ToolOutputConfiguration other = (ToolOutputConfiguration) obj;
        return Objects.equals(outputVariableNameOverride(), other.outputVariableNameOverride())
                && Objects.equals(sessionDataNamespace(), other.sessionDataNamespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolOutputConfiguration").add("OutputVariableNameOverride", outputVariableNameOverride())
                .add("SessionDataNamespace", sessionDataNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputVariableNameOverride":
            return Optional.ofNullable(clazz.cast(outputVariableNameOverride()));
        case "sessionDataNamespace":
            return Optional.ofNullable(clazz.cast(sessionDataNamespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputVariableNameOverride", OUTPUT_VARIABLE_NAME_OVERRIDE_FIELD);
        map.put("sessionDataNamespace", SESSION_DATA_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolOutputConfiguration, T> g) {
        return obj -> g.apply((ToolOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolOutputConfiguration> {
        /**
         * <p>
         * Override the tool output results to different variable name.
         * </p>
         * 
         * @param outputVariableNameOverride
         *        Override the tool output results to different variable name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariableNameOverride(String outputVariableNameOverride);

        /**
         * <p>
         * The session data namespace for tool output.
         * </p>
         * 
         * @param sessionDataNamespace
         *        The session data namespace for tool output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionDataNamespace(String sessionDataNamespace);
    }

    static final class BuilderImpl implements Builder {
        private String outputVariableNameOverride;

        private String sessionDataNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolOutputConfiguration model) {
            outputVariableNameOverride(model.outputVariableNameOverride);
            sessionDataNamespace(model.sessionDataNamespace);
        }

        public final String getOutputVariableNameOverride() {
            return outputVariableNameOverride;
        }

        public final void setOutputVariableNameOverride(String outputVariableNameOverride) {
            this.outputVariableNameOverride = outputVariableNameOverride;
        }

        @Override
        public final Builder outputVariableNameOverride(String outputVariableNameOverride) {
            this.outputVariableNameOverride = outputVariableNameOverride;
            return this;
        }

        public final String getSessionDataNamespace() {
            return sessionDataNamespace;
        }

        public final void setSessionDataNamespace(String sessionDataNamespace) {
            this.sessionDataNamespace = sessionDataNamespace;
        }

        @Override
        public final Builder sessionDataNamespace(String sessionDataNamespace) {
            this.sessionDataNamespace = sessionDataNamespace;
            return this;
        }

        @Override
        public ToolOutputConfiguration build() {
            return new ToolOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
