/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Instructions for using a tool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolInstruction implements SdkPojo, Serializable, ToCopyableBuilder<ToolInstruction.Builder, ToolInstruction> {
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instruction").getter(getter(ToolInstruction::instruction)).setter(setter(Builder::instruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()).build();

    private static final SdkField<List<String>> EXAMPLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("examples")
            .getter(getter(ToolInstruction::examples))
            .setter(setter(Builder::examples))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("examples").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTRUCTION_FIELD,
            EXAMPLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instruction;

    private final List<String> examples;

    private ToolInstruction(BuilderImpl builder) {
        this.instruction = builder.instruction;
        this.examples = builder.examples;
    }

    /**
     * <p>
     * The instruction text for the tool.
     * </p>
     * 
     * @return The instruction text for the tool.
     */
    public final String instruction() {
        return instruction;
    }

    /**
     * For responses, this returns true if the service returned a value for the Examples property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExamples() {
        return examples != null && !(examples instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Examples for using the tool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExamples} method.
     * </p>
     * 
     * @return Examples for using the tool.
     */
    public final List<String> examples() {
        return examples;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instruction());
        hashCode = 31 * hashCode + Objects.hashCode(hasExamples() ? examples() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolInstruction)) {
            return false;
        }
        ToolInstruction other = (ToolInstruction) obj;
        return Objects.equals(instruction(), other.instruction()) && hasExamples() == other.hasExamples()
                && Objects.equals(examples(), other.examples());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolInstruction").add("Instruction", instruction())
                .add("Examples", hasExamples() ? examples() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instruction":
            return Optional.ofNullable(clazz.cast(instruction()));
        case "examples":
            return Optional.ofNullable(clazz.cast(examples()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("examples", EXAMPLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolInstruction, T> g) {
        return obj -> g.apply((ToolInstruction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolInstruction> {
        /**
         * <p>
         * The instruction text for the tool.
         * </p>
         * 
         * @param instruction
         *        The instruction text for the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instruction(String instruction);

        /**
         * <p>
         * Examples for using the tool.
         * </p>
         * 
         * @param examples
         *        Examples for using the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder examples(Collection<String> examples);

        /**
         * <p>
         * Examples for using the tool.
         * </p>
         * 
         * @param examples
         *        Examples for using the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder examples(String... examples);
    }

    static final class BuilderImpl implements Builder {
        private String instruction;

        private List<String> examples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ToolInstruction model) {
            instruction(model.instruction);
            examples(model.examples);
        }

        public final String getInstruction() {
            return instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final Collection<String> getExamples() {
            if (examples instanceof SdkAutoConstructList) {
                return null;
            }
            return examples;
        }

        public final void setExamples(Collection<String> examples) {
            this.examples = ToolExampleListCopier.copy(examples);
        }

        @Override
        public final Builder examples(Collection<String> examples) {
            this.examples = ToolExampleListCopier.copy(examples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder examples(String... examples) {
            examples(Arrays.asList(examples));
            return this;
        }

        @Override
        public ToolInstruction build() {
            return new ToolInstruction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
